package com.xforceplus.janus.config.core.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.List;

import lombok.Data;

/**
 * 属地集群使用的授权配置
 *
 * @Author: xuchuanhou
 * @Date:2022/2/28下午7:30
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ApiDto {
    private String id;
    private String projectId;
    private String protocol;
    private String requestPath;
    private String requestMethod;
    private String contentType;
    private String name;
    private boolean checkToken;

    /**0：正常 2:熔断 */
    private int isLock;

    /**属地接口绑定的云端授权action*/
    private String bindAction;
    /**绑定接口httpMethod*/
    private String bindHttpMethod;

    /**header*/
    private List<FieldMappingDto> headers;
    /**参数配置*/
    private List<FieldMappingDto> params;
    /**body结构转换表达式*/
    private String bodyExpression;


}
