package com.xforceplus.janus.config.core.condition;

import com.xforceplus.apollo.condition.strategy.AndMatchStrategy;
import com.xforceplus.apollo.zookeeper.model.Condition;

import java.util.List;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/11/10上午9:59
 */
public class AndMatchCusStrategy extends AndMatchStrategy {
    @Override
    public Boolean match(List<Condition> conditionZkDTOList, Map<String, String> queryParams) {
        return conditionZkDTOList.stream().allMatch((condition) -> {
            return OperatorJudgeFactoryCus.judge(condition, this.buildRealData(condition, queryParams));
        });
    }

    String buildRealData(Condition condition, Map<String, String> queryParams) {
        String realData = (String)queryParams.get(condition.getParamName());
        return realData;
    }
}
