package com.xforceplus.janus.config.core.condition;

import com.google.common.collect.Maps;

import com.xforceplus.apollo.condition.MatchModeEnum;
import com.xforceplus.apollo.condition.strategy.MatchStrategy;

import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/11/10上午10:07
 */
public class MatchStrategyCusFactory {

    private static final Map<Integer, MatchStrategy> MATCH_STRATEGY_MAP = Maps.newHashMapWithExpectedSize(2);

    public MatchStrategyCusFactory() {
    }

    public static MatchStrategy of(Integer strategy) {
        return (MatchStrategy)MATCH_STRATEGY_MAP.get(strategy);
    }

    static {
        MATCH_STRATEGY_MAP.put(MatchModeEnum.AND.getCode(), new AndMatchCusStrategy());
        MATCH_STRATEGY_MAP.put(MatchModeEnum.OR.getCode(), new OrMatchCusStrategy());
    }
}
