package com.xforceplus.janus.config.core.init;


import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;

import lombok.extern.slf4j.Slf4j;


/**
 * 获取预警参数
 *
 * @param
 * @author xucuanhou
 * @return
 * @date 2021/12/28
 */
@Slf4j
public class MonitorDbConfigHandler implements ConfigHandler {

    private HttpConfig httpConfig;

    public MonitorDbConfigHandler() {

    }

    public MonitorDbConfigHandler(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    @Override
    public String getConfigKey() {
        return "schemaMonitorSize";
    }

    @Override
    public void doHandler(String body) {
        try {
            this.httpConfig.setSchemaMonitorSize(Integer.valueOf(body));
        } catch (Exception ex) {

        }

    }

    @Override
    public void nullValueHandler() {
    }

}