package com.xforceplus.janus.config.core.xml2json;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class XmlToJson {
    /**
     * @param forceArrSet 指定为数组
     * @return
     * @author xucuanhou
     * @date 2022/12/2
     */
    public static String toJson(String xmlBody, Set<String> forceArrSet) {
        JSONObject jsonObject = new JSONObject();
        Document document = null;
        try {
            document = DocumentHelper.parseText(xmlBody);
            //获取根节点元素对象
            org.dom4j.Element root = document.getRootElement();
            iterateXmlNodes(root, jsonObject, forceArrSet);
            return jsonObject.toString();
        } catch (DocumentException e) {
            log.error("XML2Json exception", e);
        }
        return null;
    }

    private static void iterateXmlNodes(org.dom4j.Element node, JSONObject json, Set<String> forceArrSet) {
        //获取当前元素的名称
        String nodeName = node.getName();
        //判断已遍历的JSON中是否已经有了该元素的名称
        if (json.containsKey(nodeName)) {
            //该元素在同级下有多个
            Object Object = json.get(nodeName);
            JSONArray array = null;
            if (Object instanceof JSONArray) {
                array = (JSONArray) Object;
            } else {
                array = new JSONArray();
                array.add(Object);
            }
            //获取该元素下所有子元素
            List<Element> listElement = node.elements();
            if (listElement.isEmpty()) {
                //该元素无子元素，获取元素的值
                String nodeValue = node.getTextTrim();
                array.add(nodeValue);
                json.put(nodeName, array);
                return;
            }
            //有子元素
            JSONObject newJson = new JSONObject();
            //遍历所有子元素
            for (org.dom4j.Element e : listElement) {
                //递归
                iterateXmlNodes(e, newJson, forceArrSet);

            }
            array.add(newJson);
            json.put(nodeName, array);
            return;
        }
        //该元素同级下第一次遍历
        //获取该元素下所有子元素
        List<org.dom4j.Element> listElement = node.elements();
        if (listElement.isEmpty()) {
            //该元素无子元素，获取元素的值
            String nodeValue = node.getTextTrim();
            json.put(nodeName, nodeValue);
            return;
        }
        //有子节点，新建一个JSONObject来存储该节点下子节点的值
        JSONObject object = new JSONObject();

        //遍历所有一级子节点 //递归
        for (org.dom4j.Element e : listElement) {
            iterateXmlNodes(e, object, forceArrSet);
        }
        if (CollectionUtils.isNotEmpty(forceArrSet) && forceArrSet.contains(node.getPath())) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add(object);
            json.put(nodeName, jsonArray);
        } else {
            json.put(nodeName, object);
        }

        return;
    }
}