package com.xforceplus.janus.config.core.config;

import com.xforceplus.janus.config.core.dto.ProjectDto;
import com.xforceplus.janus.config.core.util.Constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2021/12/29上午10:47
 */

@Data
public class HttpConfig {
    //    private String fetchConfigAction;
    private String authentication;

    /**
     * 上传属地配置到云端接口Action
     */
//    private String uploadProjectInfoAction;

    private ActionConfig action = new ActionConfig();

    private WebFilterCofig webfilter = new WebFilterCofig();

    private AccessConfig access = new AccessConfig();

    private String url;

    private String clientId;
    private String tcpUrl;
    private int tcpPort;

    /**
     * http 请求默认代理地址
     */
    private String proxyHost;
    private String proxyPort;

    /**
     * tcp 代理自定义地址
     */
    private String tcpProxyHost;
    private int tcpProxyPort;

    /**
     * 1:默认本地锁
     */
    private String lockType = "1";
    /**
     * schema 监控告警阈值
     */
    private Integer schemaMonitorSize;

    /**
     * cache过期时间 (s)
     */
    private long cacheTTL;
    /**
     * 最多缓存对象个数
     */
    private long cacheMaxSize;

    ProjectDto projectDto;

    private static Map<String, Object> CONFIGS = new ConcurrentHashMap<>();

    public static <T> T getConfig(String key) {
        return (T) CONFIGS.get(key);
    }

    public <T> void setConfig(String key, T value) {
        CONFIGS.put(key, value);
    }

    private String version = "1.2.3.2";

    private String clientType = Constant.CLIENT_TYPE_FRAMEWORK;
    private String clientVersion;

    /**
     * json序列化是否进行排序
     */
    private boolean jsonOrder = true;

    /**
     * 支持远程日志查询
     */
    private boolean remoteLog = true;
    private String cusLogDir;
    /**
     * 上传API
     */
    private boolean uploadApi = false;

    /**
     * 使用日志文件的创建时间来确定打印日志时间
     */
    private boolean decisionContentTimeUseFileTime = true;

    /**
     * 是否复制日志文件，已防止日志文件名中有特殊字符
     */
    private boolean copLogFile = false;

    /**
     * 消息处理线程数
     */
    private int threadnum = 1;
    /**
     *
     */
    private String clientInfo;


    /**离线版本*/
    private boolean offLine;


}
