package com.xforceplus.janus.config.core.condition;

import com.google.common.collect.Maps;

import com.xforceplus.apollo.condition.OperatorEnum;
import com.xforceplus.apollo.condition.judge.EqOperatorJudge;
import com.xforceplus.apollo.condition.judge.GTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LikeOperatorJudge;
import com.xforceplus.apollo.condition.judge.MatchOperatorJudge;
import com.xforceplus.apollo.condition.judge.NotEqOperatorJudge;
import com.xforceplus.apollo.condition.judge.OperatorJudge;
import com.xforceplus.apollo.condition.judge.RegExOperatorJudge;
import com.xforceplus.apollo.zookeeper.model.Condition;

import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @Author:
 * @Date:2022/11/10上午9:53
 */
public class OperatorJudgeFactoryCus {
    private static final Map<String, OperatorJudge> OPERATOR_JUDGE_MAP = Maps.newHashMapWithExpectedSize(7);

    public OperatorJudgeFactoryCus() {
    }

    public static Boolean judge(Condition conditionZkDTO, String realData) {
        if(OperatorEnum.NotEQ.getAlias().equals(conditionZkDTO.getOperator())){
            return Objects.isNull(conditionZkDTO) || StringUtils.isBlank(realData) ? true : ((OperatorJudge) OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator())).judge(conditionZkDTO, realData);
        }else{
            return !Objects.isNull(conditionZkDTO) && !StringUtils.isBlank(realData) ? ((OperatorJudge) OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator())).judge(conditionZkDTO, realData) : false;
        }
    }

    static {
        OPERATOR_JUDGE_MAP.put(OperatorEnum.EQ.getAlias(), new EqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.MATCH.getAlias(), new MatchOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LIKE.getAlias(), new LikeOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.REGEX.getAlias(), new RegExOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.NotEQ.getAlias(), new NotEqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.GT.getAlias(), new GTOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LT.getAlias(), new LTOperatorJudge());
    }

}
