/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.monitor;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusUploader {
    private static final Logger log = LoggerFactory.getLogger(JanusUploader.class);
    private HttpConfig httpConfig;

    public boolean uploadMonitor(MonitorParam param) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", "monitorNotice");
        String body = JacksonUtil.getInstance().toJson((Object)param);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), body, headers, null);
            log.warn(responseCus.getBody());
            return responseCus.getStatus() == 22;
        }
        catch (IOException ex) {
            log.error("\u76d1\u63a7\u4fe1\u606f\u4e0a\u4f20\u5f02\u5e38:{}", (Object)body);
            return false;
        }
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("rpcType", "http");
        headers.put("serialNo", "" + System.currentTimeMillis());
        if (StringUtils.isNotBlank((CharSequence)this.httpConfig.getProxyHost())) {
            headers.put("proxyHost", this.httpConfig.getProxyHost());
            headers.put("proxyPort", this.httpConfig.getProxyPort());
        }
        return headers;
    }

    public boolean sendStatics(Map<String, Object> businessStaticsParam) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", "acceptStatics");
        String json = JacksonUtil.getInstance().toJson(businessStaticsParam);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), json, headers, null);
            log.info("url {}", (Object)this.httpConfig.getUrl());
            log.info("json {}", (Object)json);
            log.info("headers {}", (Object)JacksonUtil.getInstance().toJson(headers));
            return responseCus.getStatus() == 22;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7edf\u8ba1\u6570\u636e\u5f02\u5e38:{}", (Object)json);
            return false;
        }
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body) {
        return this.sendJanusCmdResult(sourceType, cmdSerialKey, body, null);
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body, String serialNo) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", sourceType);
        headers.put("cmdSerialKey", cmdSerialKey);
        if (StringUtils.isNotBlank((CharSequence)serialNo)) {
            headers.put("serialNo", serialNo);
        }
        String json = JacksonUtil.getInstance().toJson(body);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), json, headers, null);
            return responseCus.getStatus() == 200;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7edf\u8ba1\u6570\u636e\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)ErrorUtil.getStackMsg((Exception)e));
            return false;
        }
    }

    public JanusUploader() {
    }

    public JanusUploader(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

