package com.xforceplus.janus.config.core.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/8/19下午5:22
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class AccessConfig {

    public static final String PERSIST_DB="db";
    public static final String PERSIST_LOG="log";

    public static final String SHARDING_DAY="d";
    public static final String SHARDING_MONTH="m";
    public static final String SHARDING_YEAR="y";

    /**默认*/
    public static final String DB_DIALECT_MYSQL="mysql";
    public static final String DB_DIALECT_POSTGRESQL="postgresql";

    private String persist;
    private String shardType=SHARDING_DAY;
    private String dialect=DB_DIALECT_MYSQL;
}
