package com.xforceplus.janus.config.core.init;

import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;

public class RemoteLogConfigHandler implements ConfigHandler {

    private HttpConfig httpConfig;


    public RemoteLogConfigHandler(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }


    @Override
    public String getConfigKey() {
        return "clientLogType";
    }


    @Override
    public void doHandler(String body) {
        synchronized (httpConfig) {
            boolean remoteLog = false;
            if(body!=null && body.equals("2")){
                remoteLog=true;
            }
            this.httpConfig.setRemoteLog(remoteLog);
        }
    }


    @Override
    public void nullValueHandler() {
    }

}