package com.xforceplus.janus.config.core.init;


import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;

import lombok.extern.slf4j.Slf4j;


/**
 * 数据库表同步配置,根据配置中心同步配置启动同步线程进行数据同步<br/> 如果该配置没有被调用(云端无配置)，需要执行本地扫描本地数据库读取配置信息 <br/> 最早执行
 *
 * @param
 * @author xucuanhou
 * @return
 * @date 2021/12/28
 */
@Slf4j
public class UploadProjectConfigHandler implements ConfigHandler {

    private HttpConfig httpConfig;

    public UploadProjectConfigHandler() {

    }

    public UploadProjectConfigHandler(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }


    @Override
    public String getConfigKey() {
        return "uploadProjectInfoAction";
    }


    @Override
    public void doHandler(String body) {
        synchronized (httpConfig) {
            this.httpConfig.getAction().setUploadProjectInfo(body);
        }
    }


    @Override
    public void nullValueHandler() {
    }

}