package com.xforceplus.janus.config.core.monitor;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 系统监控信息上传
 *
 * @Author: xuchuanhou
 * @Date:2022/3/18下午6:37
 */
@Slf4j
@NoArgsConstructor
@AllArgsConstructor
public class JanusUploader {

    private HttpConfig httpConfig;

    public boolean uploadMonitor(MonitorParam param) {
        Map<String, String> headers = getHeaders();
        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", Constant.UPLOAD_TYPE_MONITORNOTICE);
        String body = JacksonUtil.getInstance().toJson(param);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(httpConfig.getUrl(), body, headers,
                    null);
            log.warn(responseCus.getBody());
            return responseCus.getStatus() == 22;
        } catch (IOException ex) {
            log.error("监控信息上传异常:{}", body);
            return false;
        }
    }

    private Map<String, String> getHeaders() {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authentication", httpConfig.getAuthentication());
        headers.put("rpcType", "http");
        headers.put(Constant.KEY_SERIALNO, "" + System.currentTimeMillis());
        if (StringUtils.isNotBlank(httpConfig.getProxyHost())) {
            headers.put(JanusHttpUtil.KEY_PROXY_HOST, httpConfig.getProxyHost());
            headers.put(JanusHttpUtil.KEY_PROXY_PORT, httpConfig.getProxyPort());
        }

        return headers;
    }

    //向云端发送统计数据
    public boolean sendStatics(Map<String, Object> businessStaticsParam) {
        Map<String, String> headers = getHeaders();

        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", Constant.UPLOAD_TYPE_ACCEPTSTATICS);

        String json = JacksonUtil.getInstance().toJson(businessStaticsParam);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(httpConfig.getUrl(), json, headers, null);
            log.info("url {}", httpConfig.getUrl());
            log.info("json {}", json);
            log.info("headers {}", JacksonUtil.getInstance().toJson(headers));
            return responseCus.getStatus() == 22;
        } catch (Exception e) {
            log.error("上传统计数据异常:{}", json);
            return false;
        }
    }

    //向集成平台云端推送
    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body) {
        return sendJanusCmdResult(sourceType, cmdSerialKey, body, null);
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body, String serialNo) {

        Map<String, String> headers = getHeaders();

        headers.put("action", httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", sourceType);
        headers.put("cmdSerialKey", cmdSerialKey);
        if (StringUtils.isNotBlank(serialNo)) {
            headers.put(Constant.KEY_SERIALNO, serialNo);
        }

        String json = JacksonUtil.getInstance().toJson(body);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(httpConfig.getUrl(), json, headers, null);
//            log.info("url {} headers {}",httpConfig.getUrl() , JacksonUtil.getInstance().toJson(headers));
//            log.info("json {}", json);
//            log.info("status:{},{}",responseCus.getStatus(),responseCus.getBody());
            return responseCus.getStatus() == HttpStatus.SC_OK;
        } catch (Exception e) {
            log.error("上传统计数据异常:{},{}", e.getMessage(), ErrorUtil.getStackMsg(e));
            return false;
        }

    }

    /**
     *
     **/
    public String readFromObjectService(String objectKey) throws Exception {
        Map<String, String> headers = getHeaders();
        String action = HttpConfig.getConfig(Constant.KEY_ACTION_READ_OSS);
        if (StringUtils.isBlank(action)) {
            throw new Exception("读取OSS 接口未授权");
        }

        headers.put("action", action);
        headers.put(Constant.KEY_SERIALNO, objectKey);

        Map<String, Object> body = new HashMap<>();
        body.put("objectKey", objectKey);

        long starg = System.currentTimeMillis();
        JanusHttpUtil.ResponseCus resp = JanusHttpUtil.readFromGzipStream(httpConfig.getUrl(), JacksonUtil.getInstance().toJson(body), headers, null);

        log.info("http cost:" + (System.currentTimeMillis() - starg));
        if (resp.getStatus() == HttpStatus.SC_OK) {
            return resp.getBody();
        } else {
            log.error("获取超大报文：{} 失败:{}", JacksonUtil.getInstance().toJson(resp));
        }
        return null;
    }

    /**
     * 将报文压缩上传到服务端
     */
    public String upload2ObjectService(String payLoad, String businessNo) {
        Map<String, String> headers = getHeaders();
        String action = httpConfig.getAction().getUploadProjectInfo();
        if (StringUtils.isBlank(action)) {
            throw new RuntimeException("上传项目数据接口未授权，无法上传报文数据");
        }

        headers.put("action", action);
        headers.put(JanusHttpUtil.HEADER_KEY_CONTENT_TYPE, "application/octet-stream");
        headers.put("source-type", Constant.UPLOAD_TYPE_GZIP2OBJECT);
        headers.put(JanusHttpUtil.HEADER_KEY_CONTENT_ENCODING, "gzip");

        headers.put(Constant.KEY_SERIALNO, businessNo);
        JanusHttpUtil.ResponseCus resp = null;
        try {
            resp = JanusHttpUtil.doPostJsonEntire(httpConfig.getUrl(), payLoad, headers, null);
            if (resp != null && resp.getStatus() == HttpStatus.SC_OK && StringUtils.isNotBlank(resp.getBody())) {
                Map<String, String> rMap = JacksonUtil.getInstance().fromJson(resp.getBody(), Map.class);
                return rMap.get("result");
            }
        } catch (Exception ex) {
            log.error("上传消息到OSS异常:{}", ex.getMessage());
        }
        return null;
    }


}
