/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.config;

import com.xforceplus.janus.config.core.config.ConfigBuilder;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.ConfigHttpBuilder;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.config.LdapConfig;
import com.xforceplus.janus.config.core.init.JanusConfigInitRunnner;
import com.xforceplus.janus.config.core.init.MonitorDbConfigHandler;
import com.xforceplus.janus.config.core.init.RemoteLogConfigHandler;
import com.xforceplus.janus.config.core.init.UploadProjectConfigHandler;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.config.core.util.SpringContextUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class CoreAutoconfig {
    @Bean
    @ConfigurationProperties(prefix="janus")
    public HttpConfig createHttpConfig() {
        return new HttpConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="ldap")
    public LdapConfig createLdapConfig() {
        return new LdapConfig();
    }

    @Bean
    public ConfigHttpBuilder createConfigBuilder(HttpConfig httpConfig, Environment environment) {
        if (httpConfig != null) {
            if (StringUtils.isBlank((CharSequence)httpConfig.getAuthentication())) {
                httpConfig.setAuthentication(environment.getProperty("janus.authentication"));
            }
            if (StringUtils.isBlank((CharSequence)httpConfig.getUrl())) {
                httpConfig.setAuthentication(environment.getProperty("janus.url"));
            }
            if (StringUtils.isBlank((CharSequence)httpConfig.getAction().getConfig())) {
                httpConfig.getAction().setConfig(environment.getProperty("janus.action.config"));
            }
            if (httpConfig.getWebfilter() != null && environment.containsProperty("janus.webfilter.enable")) {
                httpConfig.getWebfilter().setEnable(Boolean.valueOf(environment.getProperty("janus.webfilter.enable")));
            }
            if (httpConfig.getWebfilter() != null && environment.containsProperty("janus.webfilter.exclude")) {
                httpConfig.getWebfilter().setExclude(environment.getProperty("janus.webfilter.exclude"));
            }
            if (httpConfig.getWebfilter() != null && environment.containsProperty("janus.webfilter.exclude")) {
                httpConfig.getWebfilter().setExclude(environment.getProperty("janus.webfilter.exclude"));
            }
        }
        return new ConfigHttpBuilder(httpConfig);
    }

    @Bean
    @ConditionalOnProperty(name={"janus.authentication"})
    public JanusConfigInitRunnner createConfigRunner(List<ConfigHandler> configHandlerList, ConfigBuilder configBuilder, HttpConfig httpConfig) {
        return new JanusConfigInitRunnner(configHandlerList, configBuilder, httpConfig);
    }

    @Bean
    public MonitorDbConfigHandler createMonitorDbHandler(HttpConfig httpConfig) {
        return new MonitorDbConfigHandler(httpConfig);
    }

    @Bean
    public UploadProjectConfigHandler createUploadActionHandler(HttpConfig httpConfig) {
        return new UploadProjectConfigHandler(httpConfig);
    }

    @Bean
    public JanusUploader createJanusUploader(HttpConfig httpConfig) {
        return new JanusUploader(httpConfig);
    }

    @Bean
    public SpringContextUtils createSpringContextUtils(ApplicationContext applicationContext) {
        SpringContextUtils springContextUtils = new SpringContextUtils(applicationContext);
        return springContextUtils;
    }

    @Bean
    public RemoteLogConfigHandler createRemoteLogConfigHandler(HttpConfig httpConfig) {
        return new RemoteLogConfigHandler(httpConfig);
    }
}

