/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.monitor;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusUploader {
    private static final Logger log = LoggerFactory.getLogger(JanusUploader.class);
    private HttpConfig httpConfig;

    public boolean uploadMonitor(MonitorParam param) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", "monitorNotice");
        String body = JacksonUtil.getInstance().toJson((Object)param);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), body, headers, null);
            log.warn(responseCus.getBody());
            return responseCus.getStatus() == 22;
        }
        catch (IOException ex) {
            log.error("\u76d1\u63a7\u4fe1\u606f\u4e0a\u4f20\u5f02\u5e38:{}", (Object)body);
            return false;
        }
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("rpcType", "http");
        headers.put("serialNo", "" + System.currentTimeMillis());
        if (StringUtils.isNotBlank((CharSequence)this.httpConfig.getProxyHost())) {
            headers.put("proxyHost", this.httpConfig.getProxyHost());
            headers.put("proxyPort", this.httpConfig.getProxyPort());
        }
        return headers;
    }

    public boolean sendStatics(Map<String, Object> businessStaticsParam) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", "acceptStatics");
        String json = JacksonUtil.getInstance().toJson(businessStaticsParam);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), json, headers, null);
            log.info("url {}", (Object)this.httpConfig.getUrl());
            log.info("json {}", (Object)json);
            log.info("headers {}", (Object)JacksonUtil.getInstance().toJson(headers));
            return responseCus.getStatus() == 22;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7edf\u8ba1\u6570\u636e\u5f02\u5e38:{}", (Object)json);
            return false;
        }
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body) {
        return this.sendJanusCmdResult(sourceType, cmdSerialKey, body, null);
    }

    public boolean sendJanusCmdResult(String sourceType, String cmdSerialKey, Object body, String serialNo) {
        Map<String, String> headers = this.getHeaders();
        headers.put("action", this.httpConfig.getAction().getUploadProjectInfo());
        headers.put("source-type", sourceType);
        headers.put("cmdSerialKey", cmdSerialKey);
        if (StringUtils.isNotBlank((CharSequence)serialNo)) {
            headers.put("serialNo", serialNo);
        }
        String json = JacksonUtil.getInstance().toJson(body);
        try {
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), json, headers, null);
            return responseCus.getStatus() == 200;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7edf\u8ba1\u6570\u636e\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)ErrorUtil.getStackMsg((Exception)e));
            return false;
        }
    }

    public String readFromObjectService(String objectKey) throws Exception {
        Map<String, String> headers = this.getHeaders();
        String action = (String)HttpConfig.getConfig("action_read_oss");
        if (StringUtils.isBlank((CharSequence)action)) {
            throw new Exception("\u8bfb\u53d6OSS \u63a5\u53e3\u672a\u6388\u6743");
        }
        headers.put("action", action);
        headers.put("serialNo", objectKey);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("objectKey", objectKey);
        long starg = System.currentTimeMillis();
        JanusHttpUtil.ResponseCus resp = JanusHttpUtil.readFromGzipStream(this.httpConfig.getUrl(), JacksonUtil.getInstance().toJson(body), headers, null);
        log.info("http cost:" + (System.currentTimeMillis() - starg));
        if (resp.getStatus() == 200) {
            return resp.getBody();
        }
        log.error("\u83b7\u53d6\u8d85\u5927\u62a5\u6587\uff1a{} \u5931\u8d25:{}", (Object)JacksonUtil.getInstance().toJson((Object)resp));
        return null;
    }

    public String upload2ObjectService(String payLoad, String businessNo) {
        Map<String, String> headers = this.getHeaders();
        String action = this.httpConfig.getAction().getUploadProjectInfo();
        if (StringUtils.isBlank((CharSequence)action)) {
            throw new RuntimeException("\u4e0a\u4f20\u9879\u76ee\u6570\u636e\u63a5\u53e3\u672a\u6388\u6743\uff0c\u65e0\u6cd5\u4e0a\u4f20\u62a5\u6587\u6570\u636e");
        }
        headers.put("action", action);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("source-type", "Gzip2Oss");
        headers.put("Content-Encoding", "gzip");
        headers.put("serialNo", businessNo);
        JanusHttpUtil.ResponseCus resp = null;
        try {
            resp = JanusHttpUtil.doPostJsonEntire(this.httpConfig.getUrl(), payLoad, headers, null);
            if (resp != null && resp.getStatus() == 200 && StringUtils.isNotBlank((CharSequence)resp.getBody())) {
                Map rMap = (Map)JacksonUtil.getInstance().fromJson(resp.getBody(), Map.class);
                return (String)rMap.get("result");
            }
        }
        catch (Exception ex) {
            log.error("\u4e0a\u4f20\u6d88\u606f\u5230OSS\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return null;
    }

    public JanusUploader() {
    }

    public JanusUploader(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

