/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.config.core.util;

import com.xforceplus.apollo.utils.IOUtil;
import com.xforceplus.apollo.utils.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(JanusHttpUtil.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig;
    private static HttpClient httpClient;
    private static volatile int MAX_TIMEOUT;
    private static volatile int MAX_SOCKET_TIMEOUT;
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    public static final String CONTENT_TYPE_TEXT_STREAM = "application/octet-stream";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_KEY_CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String KEY_PROXY_HOST = "proxyHost";
    public static final String KEY_PROXY_PORT = "proxyPort";

    public static void resetRequestConfig(int connectionRequestTimeOut, int connectTimeout, int maxSocketTimeout) {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        if (connectTimeout > 0) {
            MAX_TIMEOUT = connectTimeout;
        }
        if (maxSocketTimeout > 0) {
            MAX_SOCKET_TIMEOUT = maxSocketTimeout;
        }
        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
        configBuilder.setConnectTimeout(MAX_TIMEOUT);
        configBuilder.setSocketTimeout(MAX_SOCKET_TIMEOUT);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }

    public static String doPost(String url) throws IOException {
        return JanusHttpUtil.doPost(url, null);
    }

    public static String doGet(String url) throws IOException {
        return JanusHttpUtil.doGet(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doDeleteEntire(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        HttpDelete delete = new HttpDelete(JanusHttpUtil.buildQueryUrlWithParams(url, params));
        delete.addHeader(HEADER_KEY_CONTENT_TYPE, APPLICATION_JSON);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                delete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        InputStream instream = null;
        try {
            delete.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
            HttpResponse response = httpClient.execute((HttpUriRequest)delete);
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                String result = JanusHttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                responseCus.setBody(result);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doPutPatchEntire(String url, String httpMethod, String json, Map<String, String> headers, Map<String, Object> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        HttpPut requestBase = null;
        if ("PUT".equalsIgnoreCase(httpMethod)) {
            requestBase = new HttpPut(JanusHttpUtil.buildQueryUrlWithParams(url, params));
        } else if ("PATCH".equalsIgnoreCase(httpMethod)) {
            requestBase = new HttpPatch(JanusHttpUtil.buildQueryUrlWithParams(url, params));
        }
        InputStream instream = null;
        try {
            requestBase.addHeader(HEADER_KEY_CONTENT_TYPE, APPLICATION_JSON);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    requestBase.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, DEFAULT_CHARSET);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                requestBase.setEntity((HttpEntity)se);
            }
            requestBase.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
            HttpResponse response = httpClient.execute((HttpUriRequest)requestBase);
            HttpEntity entity = response.getEntity();
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            if (entity != null) {
                instream = entity.getContent();
                String result = JanusHttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                responseCus.setBody(result);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    public static String doPost(String url, Map<String, Object> params) throws IOException {
        ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(url, null, null, params);
        return responseCus.getBody();
    }

    public static String doGet(String url, Map<String, Object> params) throws IOException {
        Object result = null;
        ResponseCus responseCus = JanusHttpUtil.doGetEntire(url, params, true, null);
        return responseCus.getBody();
    }

    public static String buildQuery(Map<String, Object> params, String charset) throws IOException {
        if (params != null && !params.isEmpty()) {
            StringBuilder query = new StringBuilder();
            Set<Map.Entry<String, Object>> entries = params.entrySet();
            boolean hasParam = false;
            for (Map.Entry<String, Object> entry : entries) {
                String value;
                String name = entry.getKey();
                if (!StringUtil.areNotEmpty((String[])new String[]{name, value = String.valueOf(entry.getValue())})) continue;
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            return query.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        BufferedReader in = null;
        try {
            String result;
            String line;
            in = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            String string = result = buffer.toString();
            return string;
        }
        finally {
            if (null != stream) {
                stream.close();
            }
            if (null != in) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http(String url, Map<String, String> params) {
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            URL u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty(HEADER_KEY_CONTENT_TYPE, "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), DEFAULT_CHARSET);
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception var11) {
            var11.printStackTrace();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), DEFAULT_CHARSET));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception var13) {
            var13.printStackTrace();
        }
        return buffer.toString();
    }

    public static String doPostJson(String url, String json) {
        String result;
        try {
            ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(url, json, null, null);
            result = responseCus.getBody();
        }
        catch (IOException var4) {
            var4.printStackTrace();
            result = var4.getMessage();
        }
        return result;
    }

    public static String doPostForm(String url, Map<String, String> param) {
        HttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, DEFAULT_CHARSET);
                httpPost.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        return resultString;
    }

    public static String buildQueryUrlWithParams(String url, Map<String, Object> params) throws IOException {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        StringBuilder urlSb = new StringBuilder(url);
        String urlParam = JanusHttpUtil.buildQuery(params, DEFAULT_CHARSET);
        if (url.contains("?") && url.contains("=")) {
            urlSb.append("&");
        } else {
            urlSb.append("?");
        }
        urlSb.append(urlParam);
        return urlSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doGetEntire(String url, Map<String, Object> params, boolean json, Map<String, String> headers) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        InputStream instream = null;
        try {
            HttpGet httpget = new HttpGet(JanusHttpUtil.buildQueryUrlWithParams(url, params));
            httpget.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
            if (json) {
                httpget.addHeader(HEADER_KEY_CONTENT_TYPE, APPLICATION_JSON);
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpget.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                responseCus.setBody(JanusHttpUtil.getStreamAsString(instream, DEFAULT_CHARSET));
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    public static RequestConfig getProxyRequestConfig(Map<String, String> headers) {
        if (headers == null || !headers.containsKey(KEY_PROXY_HOST)) {
            return requestConfig;
        }
        String proxyHost = headers.get(KEY_PROXY_HOST);
        String proxyPort = headers.get(KEY_PROXY_PORT);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(MAX_TIMEOUT);
        configBuilder.setSocketTimeout(MAX_SOCKET_TIMEOUT);
        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
        if (StringUtils.isNotBlank((CharSequence)proxyPort)) {
            configBuilder.setProxy(new HttpHost(proxyHost, Integer.valueOf(proxyPort).intValue()));
        } else {
            configBuilder.setProxy(new HttpHost(proxyHost));
        }
        return configBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static ResponseCus doPostJsonEntire(String url, String json, Map<String, String> headers, Map<String, Object> params) throws IOException {
        block24: {
            block23: {
                responseCus = new ResponseCus();
                instream = null;
                contentType = headers.get("Content-Type");
                if (contentType != null && contentType.contains("form")) {
                    return JanusHttpUtil.doPostForm(url, headers, params);
                }
                try {
                    httpPost = new HttpPost(JanusHttpUtil.buildQueryUrlWithParams(url, params));
                    if (contentType == null) {
                        httpPost.addHeader("Content-Type", "application/json");
                    }
                    if (MapUtils.isNotEmpty(headers)) {
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            httpPost.addHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)json)) ** GOTO lbl55
                    if (!headers.containsKey("Content-Encoding") || !headers.get("Content-Encoding").equals("gzip")) ** GOTO lbl51
                    if (!StringUtils.isBlank((CharSequence)json)) break block23;
                    var7 = null;
                }
                catch (Throwable var14_17) {
                    IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
                    throw var14_17;
                }
                IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
                return var7;
            }
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            var10_11 = null;
            try {
                gzip.write(json.getBytes("UTF-8"));
                gzip.close();
                gzipEncrypt = out.toByteArray();
                httpPost.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(gzipEncrypt), (long)gzipEncrypt.length));
                break block24;
            }
            catch (Throwable var11_14) {
                var10_11 = var11_14;
                throw var11_14;
            }
            finally {
                if (gzip != null) {
                    if (var10_11 != null) {
                        try {
                            gzip.close();
                        }
                        catch (Throwable var11_13) {
                            var10_11.addSuppressed(var11_13);
                        }
                    } else {
                        gzip.close();
                    }
                }
            }
lbl51:
            // 1 sources

            se = new StringEntity(json, "UTF-8");
            if (contentType == null || !contentType.contains("xml")) {
                se.setContentType("text/json");
            }
            httpPost.setEntity((HttpEntity)se);
        }
        httpPost.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
        response = JanusHttpUtil.httpClient.execute((HttpUriRequest)httpPost);
        responseCus.setStatus(response.getStatusLine().getStatusCode());
        entity = response.getEntity();
        if (entity != null) {
            instream = entity.getContent();
            responseCus.setBody(JanusHttpUtil.getStreamAsString(instream, "UTF-8"));
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doPostForm(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        InputStream instream = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (httpPost.getFirstHeader(HEADER_KEY_CONTENT_TYPE) == null) {
                httpPost.addHeader(HEADER_KEY_CONTENT_TYPE, "application/x-www-form-urlencoded;charset=utf-8");
            }
            httpPost.setHeader("Accept", APPLICATION_JSON);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs));
            httpPost.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            responseCus.setStatus(httpResponse.getStatusLine().getStatusCode());
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                instream = httpEntity.getContent();
                responseCus.setBody(JanusHttpUtil.getStreamAsString(instream, DEFAULT_CHARSET));
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus readFromGzipStream(String url, String json, Map<String, String> headers, Map<String, Object> params) throws IOException {
        Object instream;
        ResponseCus responseCus;
        block24: {
            responseCus = new ResponseCus();
            instream = null;
            try {
                HttpPost httpPost = new HttpPost(JanusHttpUtil.buildQueryUrlWithParams(url, params));
                String contentType = headers.get(HEADER_KEY_CONTENT_TYPE);
                if (contentType == null) {
                    httpPost.addHeader(HEADER_KEY_CONTENT_TYPE, APPLICATION_JSON);
                }
                if (MapUtils.isNotEmpty(headers)) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                StringEntity se = new StringEntity(json, DEFAULT_CHARSET);
                if (contentType == null || !contentType.contains("xml")) {
                    se.setContentType(CONTENT_TYPE_TEXT_JSON);
                }
                httpPost.setEntity((HttpEntity)se);
                httpPost.setConfig(JanusHttpUtil.getProxyRequestConfig(headers));
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                responseCus.setStatus(response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                if (entity == null) break block24;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (GZIPInputStream ginzip = new GZIPInputStream(entity.getContent());){
                    int offset;
                    byte[] buffer = new byte[1024];
                    boolean var7 = true;
                    while ((offset = ginzip.read(buffer)) != -1) {
                        out.write(buffer, 0, offset);
                    }
                    out.flush();
                    responseCus.setBody(out.toString());
                }
                catch (IOException var24) {
                    var24.printStackTrace();
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    static {
        MAX_TIMEOUT = 3000;
        MAX_SOCKET_TIMEOUT = 60000;
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory()).build();
        connMgr = new PoolingHttpClientConnectionManager(registry);
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal() / 2);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(MAX_TIMEOUT);
        configBuilder.setSocketTimeout(MAX_SOCKET_TIMEOUT);
        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).build();
    }

    public static class ResponseCus
    implements Serializable {
        int status = 500;
        String body;

        public ResponseCus(int status, String body) {
            this.status = status;
            this.body = body;
        }

        public ResponseCus() {
        }

        public int getStatus() {
            return this.status;
        }

        public String getBody() {
            return this.body;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseCus)) {
                return false;
            }
            ResponseCus other = (ResponseCus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseCus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "JanusHttpUtil.ResponseCus(status=" + this.getStatus() + ", body=" + this.getBody() + ")";
        }
    }
}

