package com.xforceplus.janus.framework.cmd;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.event.AckTuple;
import com.xforceplus.janus.framework.event.EventInitListener;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.SealedMessageEventListener;

import lombok.extern.slf4j.Slf4j;

/**
 * 集成平台命令消息接收
 *
 * @Author: xuchuanhou
 * @Date:2022/4/7下午5:41
 */
@Slf4j
@SealedMessageEventListener(requestName = "janusInternalCmd")
public class JanusCmdListener implements ISealedMessageEventListener {

    @Override
    public AckTuple<Boolean, String> onEvent(SealedMessageEvent sealedMessageEvent) {
        log.info(JacksonUtil.getInstance().toJson(sealedMessageEvent.getSealedMessage().getHeader()));

        String sourceType = sealedMessageEvent.getSealedMessage().getHeader().getOthers().get("sourceType");

        IJanusCmdHandler janusCmdHandler = EventInitListener.JANUS_CMD_HANDLERS.get(sourceType);
        if (janusCmdHandler == null) {
            log.error("janusCmd sourceType {} 没有命令处理器", sourceType);
        } else {
            janusCmdHandler.doHandler(sealedMessageEvent.getSealedMessage());
        }

        AckTuple<Boolean, String> ack = new AckTuple<>(true, "接收成功");
        return ack;
    }
}
