package com.xforceplus.janus.framework.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/4/6下午4:11
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MessageDto implements Serializable {

    //回执正常
    public static final String RECEIPT_STATUS_NORMAL = "1";
    //无回执
    public static final String RECEIPT_STATUS_NULL = "2";
    //回执异常
    public static final String RECEIPT_STATUS_EXCEPTION = "0";
    /**
     * 无订阅
     */
    public static final String RECEIPT_STATUS_NOSUBER = "4";
    /**部分正常*/
    public static final String STATUS_PART_SUCCESS = "5";

    /**消息ID*/
    private String msgId;

    private String infoType;
    /**业务请求中文名称*/
    private String infoTypeName;
    /**消息创建时间*/
    private String createdTime;
    /**回执状态*/
    private String receiptStatus;

    //消息发送方代码
    private String customerNo;
    //消息发送方名称
    private String customerName;

    //业务代码
    private String businessNo;
    /**上一步关联的业务代码，例如发票号码关联的结算单号等*/
    private String transNo;

}
