package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.service.AccessRecordService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/5下午2:03
 */
@Slf4j
public class DbAccessRecordConsumer implements AccessRecordConsumer {

    @Autowired
    private AccessRecordService accessRecordService;

    @Autowired
    private JanusUploader janusUploader;

    @Override
    public void consumeAccessRecord() {
        while (true) {
            try {
                List<AccessRecord> records = AccessRecordCache.takeBatch();
                if (CollectionUtils.isEmpty(records)) {
                    continue;
                }
                accessRecordService.saveBatch(records);

            } catch (InterruptedException exception) {
            } catch (Throwable tr) {
                log.error("saveBatch  AccessRecord error", tr);
            }
        }
    }

    long lastSendTime = 0;

    long successCount = 0;
    long failedCount = 0;

    public void noticeException(AccessRecord record) {
        if (record.getStatus() != HttpStatus.SC_OK) {
            failedCount++;
        } else {
            successCount++;
        }

        if (lastSendTime > 0 && (System.currentTimeMillis() - lastSendTime) < 300000) {
            return;
        }

        // TODO 增加失败率
        if(failedCount>0 && StringUtils.isNotBlank(record.getAction())){
            MonitorParam monitorParam = new MonitorParam();
            monitorParam.setDataType(MonitorParam.DATA_TYPE_HTTP);
            monitorParam.setNoticeType(MonitorParam.NOTICE_TYPE_EMAIL);
            monitorParam.setNoticeContent(String.format("projectName 接口[%s]异常，状态码:%d", record.getAction(), record.getStatus()));
            monitorParam.setSubject("接口异常");
            //供云端绑定监控管理使用
            monitorParam.setObjectId(record.getAction());
            monitorParam.setMonitorType(MonitorParam.MONITOR_TYPE_SERVICE);
            monitorParam.setIndicator(MonitorParam.MONITOR_INDICATOR_SERVICE_ERROR);
            janusUploader.uploadMonitor(monitorParam);
            lastSendTime = System.currentTimeMillis();
        }

        successCount = 0;
        failedCount = 0;

    }


}
