package com.xforceplus.janus.framework.record.portal;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 启动后自动上报一次本地接口
 *
 * @Author: xuchuanhou
 * @Date:2022/5/12下午5:09
 */
@Slf4j
public class RestUrlUploader {

    @Setter
    WebApplicationContext webApplicationContext;

//    @Override
//    public void run(String... args) throws Exception {
//        List<Map<String, String>>  urls = getUrl();
//        if(CollectionUtils.isNotEmpty(urls)){
//            new Thread(()->{
//                synchronized (httpConfig){
//                    try {
//                        httpConfig.wait();
//                        janusUploader.sendJanusCmdResult("uploadApis","1",urls);
//                    }catch (InterruptedException ex ){
//
//                    }
//                }
//
//            }).start();
//        }
//    }

    public List<Map<String, String>> getUrl() {
        RequestMappingHandlerMapping mapping = webApplicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        if (mapping == null) {
            return null;
        }

        // 获取url与类和方法的对应信息
        Map<RequestMappingInfo, HandlerMethod> map = mapping.getHandlerMethods();
        // 初始化map集合
        List<Map<String, String>> listMap = new ArrayList<>();
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            Map<String, String> initMap = new HashMap<>();
            RequestMappingInfo info = entry.getKey();
            // 请求类型
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            // 请求url
            PatternsRequestCondition pattern = info.getPatternsCondition();
            // 如果类型不为空则获取
            Set<RequestMethod> methods = methodsCondition.getMethods();
            if (!ObjectUtils.isEmpty(pattern) && !CollectionUtils.isEmpty(methods)) {
                if (!CollectionUtils.isEmpty(pattern.getPatterns())) {
                    Set<String> patterns = pattern.getPatterns();
                    for (String url : patterns) {
                        initMap.put("requestPath", url);
                        initMap.put("name", url.replaceAll("/", "_").substring(1));
                    }
                    for (RequestMethod requestMethod : methods) {
                        initMap.put("requestMethod", requestMethod.toString().toUpperCase());
                    }
                }
                listMap.add(initMap);
            }
        }
        return listMap;
    }
}
