package com.xforceplus.janus.framework.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: xuchuanhou
 * @Date:2022/4/8上午9:52
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Result<T> {
    private String code;
    private String message;

    private T result;

    public Result(ResultCode responseCode) {
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public Result(T result, ResultCode responseCode) {
        this.result = result;
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public static <T> Result<T> ok(T body) {
        Result<T> response = new Result<>();
        response.setResult(body);
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public static <T> Result<T> ok() {
        Result<T> response = new Result<>();
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public enum ResultCode {
        // ---------------------------
        // 0000       处理成功
        // 1000～1999 区间表示参数错误
        // 2000～2999 区间表示用户错误
        // 3000～3999 区间表示系统业务异常
        // ---------------------------

        OK("1", "处理成功"),
        FAILED("0", "处理失败");

        private final String code;
        private final String message;

        ResultCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }

        public String getMessage() {
            return message;
        }
    }


}
