package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.framework.event.dto.ClientInfo;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/9下午4:59
 */
@Slf4j
@Order(0)
public class ProjectClientInitHandler implements ConfigHandler {

   @Setter
   private InternalListener messageListener;

    @Override
    public void doHandler(String body) {
        try {
            if (StringUtils.isNotBlank(body) && MCFactory.getInstance() != null) {
            }
        }catch (RuntimeException ex){
            //MCFactory 为空才创建
            ClientInfo clientInfo = JacksonUtil.getInstance().fromJson(body, ClientInfo.class);
            MCFactory mcFactory = MCFactory.getInstance(clientInfo.getClientId(), clientInfo.getUrl(), clientInfo.getPort());
            mcFactory.registerListener(messageListener);
            return;
        }

    }

    @Override
    public String getConfigKey() {
        return "client";
    }
}
