package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContent;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.service.AccessRecordService;

import lombok.Setter;

/**
 * 命令执行：查询请求履历详情
 * @Author: xuchuanhou
 * @Date:2022/4/8上午10:19
 */
@JanusCmdAnnotation(sourceType = "getRequestRecordDetails")
public class RequestRecordDetailCmdHandler implements IJanusCmdHandler {

    @Setter
    JanusUploader janusUploader;

    @Setter
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = sealedMessage.getHeader().getOthers().get("businessTime");
        String contentId = sealedMessage.getHeader().getOthers().get("contentId");

        AccessContent content  = accessRecordService.queryByConentId(contentId,requstTime);
        AccessContentDto contenDto = null;
        Result<AccessContentDto> result=null;
        if(content!=null){
            contenDto  = JacksonUtil.getInstance().fromJson(content.getContent(),AccessContentDto.class);
            result = Result.ok(contenDto);
        }else{
            result = new Result(null,Result.ResultCode.FAILED);
        }

        janusUploader.sendJanusCmdResult(sealedMessage.getHeader().getOthers().get("sourceType"), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

//    @Override
//    public String getSourceType() {
//        return "getRequestRecordDetails";
//    }
}
