package com.xforceplus.janus.framework.record.interceptor;

import com.xforceplus.apollo.utils.Base64Util;
import com.xforceplus.apollo.utils.code.GZipUtils;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.servlet.HandlerInterceptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 大报文拆分拦截器，大报文拆分： 将不同任务号的数据存放到数据库临时表，请求结尾标记进行数据查询组装，将组装后的完整数据响应返回
 */
@Slf4j
public class BigRequestInterceptor implements HandlerInterceptor {


    @Setter
    private BigDataTmpRepository bigDataTmpRepository;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String contentEncoding = request.getHeader("Content-Encoding");

        String taskId = request.getHeader("big-data-split-task-id");
        // 如果对内容进行了压缩，则解压
        if (StringUtils.isNotBlank(taskId)) {
            int splitCount = Integer.valueOf(request.getHeader("big-data-split-count"));
            int splitIndex = Integer.valueOf(request.getHeader("big-data-split-index"));

            String body = null;
            if(request instanceof CustomHttpServletRequestWrapper){
                body =  getRequestBody((CustomHttpServletRequestWrapper)request).toString();
            }

            if (splitCount - 1 == splitIndex) {
                List<BigRequestTmpDto> dataDetails = bigDataTmpRepository.getByTaskId(taskId);
                int outTimes = 0;
                while ((CollectionUtils.isEmpty(dataDetails) || dataDetails.size() - 1 != splitCount)&& outTimes < 9) {
                    try {
                        Thread.sleep(1000);
                    } catch (Exception ex) {
                    }
                    dataDetails = bigDataTmpRepository.getByTaskId(taskId);
                    outTimes++;
                }
                if (CollectionUtils.isNotEmpty(dataDetails) && dataDetails.size() == splitCount- 1 ) {
                    StringBuilder stringBuilder = new StringBuilder();
                    dataDetails.forEach(bq -> {
                        stringBuilder.append(bq.getContent());
                    });
                    stringBuilder.append(body);

                   byte[] decodeChar= Base64Util.decode(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    if (request instanceof CustomHttpServletRequestWrapper) {
                        byte[] ungzipBody = GZipUtils.ungzip(decodeChar);
                        ((CustomHttpServletRequestWrapper) request).setBody(new String(ungzipBody).getBytes());

//                        ((CustomHttpServletRequestWrapper) request).addHeader("Content-Type","application/json");

                    }
                    response.addHeader("big-request-finish","true");
                    return true;
                } else {
                    //返回异常
                    String sjycBody = "{\"code\":\"0\",\"message\":\"大报文拆分异常数据不全\"}";
                    response.getWriter().write(sjycBody);
                    return false;
                }

            } else {
                BigRequestTmpDto requestBody = new BigRequestTmpDto(taskId, splitIndex, body, DateFormatUtils.format(new Date(), "yyyyMMddHHmmss"));
                bigDataTmpRepository.saveBigDataTmp(requestBody);
                String sjycBody = "{\"code\":\"1\",\"message\":\"已经上传\",\"big-request-finish\":false}";
                response.addHeader("big-request-finish","false");
                response.getWriter().write(sjycBody);
                return false;
            }
        } else {
            return true;
        }
    }

    private StringBuilder getRequestBody(CustomHttpServletRequestWrapper request) {
        StringBuilder requestBodySB = new StringBuilder();
        try (BufferedReader br = request.getReader()) {
            String line = null;
            while ((line = br.readLine()) != null) {
                requestBodySB.append(line);
            }
            br.close();
            return requestBodySB;
        } catch (IOException ex) {
        }

        return requestBodySB;
    }

}
