package com.xforceplus.janus.framework.record.interceptor;


import com.xforceplus.janus.config.core.config.HttpConfig;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Date:2022/3/6下午8:08
 */
@Slf4j
public class WebMvcConfig implements WebMvcConfigurer {

    @Setter
    private RequestInterceptor requestInterceptor;

    @Setter
    private BigRequestInterceptor bigRequestInterceptor;

    @Setter
    private HttpConfig httpConfig;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        if (!httpConfig.getWebfilter().isEnable()) {
            return;
        }

        String[] excludePathPatterns = new String[]{"/**.html", "/**.js", "/janus/record/resend", "/error"};
        if (httpConfig.getWebfilter()!=null&&StringUtils.isNotBlank(httpConfig.getWebfilter().getExclude())){
            excludePathPatterns = ArrayUtils.addAll(excludePathPatterns, httpConfig.getWebfilter().getExclude().split(","));
        }

        registry
                .addInterceptor(requestInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns);
        if(bigRequestInterceptor!=null) {
            registry.addInterceptor(bigRequestInterceptor);
        }
    }


}
