package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/17下午5:44
 */
@Slf4j
public class BigDataTmpRepository {

    @Setter
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;

    private static final String insertSql="insert into t_janus_big_request_tmp(task_id,task_index,content,created_time)values(:taskId,:taskIndex,:content,:createdTime)";

    public boolean saveBigDataTmp(BigRequestTmpDto requestBody){
        try {
            Map param = BeanMapperUtil.map(requestBody, Map.class);
           int count = namedPrmtrJdbcTemplate.update(insertSql, param);
           return count ==1;
        }catch (Exception ex){
            log.error("saveBigDataTmp ",ex);
            return false;
        }
    }

    private static final String queryByTaskId="select * from  t_janus_big_request_tmp where task_id=:taskId order by task_index";

    public List<BigRequestTmpDto> getByTaskId(String taskId){
        List<BigRequestTmpDto> acc =null;

        Map<String,String> param =new HashMap<String,String>(){{put("taskId",taskId);}};
        try {
            acc = namedPrmtrJdbcTemplate.query(queryByTaskId, param, new RowMapper<BigRequestTmpDto>() {
                @Override
                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    requestTmpDto.setContent(rs.getString("content"));
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));

                    return requestTmpDto;
                }
            });
        }catch (EmptyResultDataAccessException ex){

        }
        return acc;

    }



}
