package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessRecord;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class LogAccessRecordConsumer implements AccessRecordConsumer {

    @Override
    public void consumeAccessRecord() {

        while (true) {
            try {
                AccessRecord record = AccessRecordCache.takeRecord();
                String recordStr = JacksonUtil.getInstance().toJson(record);
                log.info(recordStr);
            } catch (InterruptedException exception) {
                log.error(ErrorUtil.getStackMsg(exception));
            } catch (Throwable tr) {

            }
        }


    }
}
