package com.xforceplus.janus.framework.dto;

import com.xforceplus.apollo.utils.JacksonUtil;

import java.util.HashMap;
import java.util.Map;


public class CmdBody {
    private String body;
    private Map<String, String> properties;

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getProperties() {
        if (properties == null) {
            properties = new HashMap<>();
        }
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private String propertiesToString() {
        if (properties == null || properties.isEmpty()) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            sb.append(key);
            sb.append(value);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return "CmdBody{" +
                "body='" + body + '\'' +
                ", properties=" + propertiesToString() +
                '}';
    }

    public static void main(String[] args) {
//        private String startTime;
//        private String endTime;
//        private String cmd;
//        private String page;
//        private String limit;
//        private String uuid;
        CmdBody body= new CmdBody();
        body.setBody("cat /logs/apollo | grep  '2022-07-21 10:05'  | grep 'org.springframework.scheduling.concurrent' -n");
        body.getProperties().put("startTime","2022-07-20 10:05");
        body.getProperties().put("endTime","2022-07-21 10:05");
        body.getProperties().put("page","1");
        body.getProperties().put("limit","2048");
        System.out.println(JacksonUtil.getInstance().toJson(body));
    }
}