package com.xforceplus.janus.framework.event;


import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
public class EventInitListener implements ApplicationListener<ContextRefreshedEvent> {


   public static ConcurrentHashMap<String, ISealedMessageEventListener> EVENT_HANDLERS = new ConcurrentHashMap<>();

    /**
     * key cmd
     */
    public static  ConcurrentHashMap<String, IJanusCmdHandler> JANUS_CMD_HANDLERS = new ConcurrentHashMap<>();


    public void register(String eventType, ISealedMessageEventListener sealedMessageEventListener) {
        if (StringUtils.isBlank(eventType)) {
            log.warn("SealedMessageEvent事件处理器名称不能为空！！！");
        }
        if (EVENT_HANDLERS.containsKey(eventType)) {
            log.warn("{}的SealedMessageEvent事件处理器已存在，将替换最新的处理器！！！", eventType);
        }
        EVENT_HANDLERS.put(eventType, sealedMessageEventListener);
        log.info("{}的SealedMessageEvent事件处理器注册成功！", eventType);
    }

    public void clear() {
        EVENT_HANDLERS.clear();
        log.warn("所有的的SealedMessageEvent事件处理器已注销！！！");
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(SealedMessageEventListener.class);
        if (null != beans) {
            beans.forEach((k, v) -> {
                String requestName = v.getClass().getAnnotation(SealedMessageEventListener.class).requestName();
                register(requestName, (ISealedMessageEventListener) v);
            });
        }
        Map<String, Object> janusCmdHandlerMap = event.getApplicationContext().getBeansWithAnnotation(JanusCmdAnnotation.class);

        if (null != janusCmdHandlerMap) {
            janusCmdHandlerMap.forEach((k, v) -> {
                String sourceType = v.getClass().getAnnotation(JanusCmdAnnotation.class).sourceType();

                JANUS_CMD_HANDLERS.put(sourceType, (IJanusCmdHandler) v);
            });
        }

    }

}
