package com.xforceplus.janus.framework.event;

/**
 * 消息发送后用于接收业务的反馈
 *
 * @Author: xuchuanhou
 * @Date:2022/8/22上午11:06
 */
@FunctionalInterface
public interface IBusinessAckListener {


    /**
     * 消息发送后接收业务处理结果
     * @param success 业务是否处理成功
     * @response response 业务处理响应结果
     * @author xucuanhou
     * @date 2022/8/22
     */
    boolean receiveBusinessAck(boolean success, String response);
}
