package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.Constants;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.framework.config.CusConfiguration;

import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

import lombok.Data;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
public class SealedMessageEventBus {

    @Setter
    private DefaultSealedMessageEventListener defaultSealedMessageEventListener;


    @Async(value = CusConfiguration.TASK_EXECUTOR_NAME)
    @EventListener(classes = SealedMessageEvent.class)
    public void sealedMessageEvent(final SealedMessageEvent event) {

        ISealedMessageEventListener sealedMessageEventListener = EventInitListener.EVENT_HANDLERS.get(event.getRequestName());
        if (null == sealedMessageEventListener) {
            sealedMessageEventListener = EventInitListener.EVENT_HANDLERS.get("*");
            if (null == sealedMessageEventListener) {
                sealedMessageEventListener = defaultSealedMessageEventListener;
            }
        }
        AckTuple<Boolean, String> ackTuple = null;
        try {
            ackTuple = sealedMessageEventListener.onEvent(event);
        } catch (Exception ex) {
            log.error("msgId:{}处理异常,{}", event.getSealedMessage().getHeader().getMsgId(), ErrorUtil.getStackMsg(ex));
            try {
                MCFactory.getInstance().sendMessage(SealedMessageBuilder.buildReceiptMessage(event.getSealedMessage(), false, ex.getMessage()));
            } catch (Exception recpEx) {
                log.error(ErrorUtil.getStackMsg(recpEx));
            }
        }
        if (null == ackTuple) {
            log.error("{} 缺失有效回执，请补充回执内容！！！",event.getSealedMessage().getHeader().getMsgId());
            return;
        }
        SealedMessage sealedMessage = event.getSealedMessage();
        if (sealedMessage.getHeader().getRequestName().contains(Constants.REQUEST_RECEIPT) || sealedMessage.getHeader().getRequestName().contains(Constants.REQUEST_KEEP_ALIVED)) {
            return;
        }
        try {
            MCFactory.getInstance().sendMessage(SealedMessageBuilder.buildReceiptMessage(sealedMessage, ackTuple.getStatus(), ackTuple.getMessage()));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("发送回执异常:{}", e);
        }
    }
}
