package com.xforceplus.janus.framework.record.cache;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.record.domain.LocalClusterLogQuery;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

/**
 * 日志查询指令缓存
 */
@Slf4j
public class SysCmdCache {
    private static final int size = 500;
    private static final BlockingQueue<LocalClusterLogQuery> RECORDS = new ArrayBlockingQueue(size);

    public static void put(LocalClusterLogQuery record) {
        if (record == null) {
            return;
        }
        boolean result = RECORDS.offer(record);
        if (!result) {
            log.error("record queue is full ,quantity:{},record: {}", size, JacksonUtil.getInstance().toJson(record));

        }
    }

    public static LocalClusterLogQuery poll()  {
        return RECORDS.poll();
    }

}
