package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.RecordRetryHandler;
import com.xforceplus.janus.framework.record.service.AccessRecordService;

import com.xforceplus.janus.framework.util.IPUtils;
import org.apache.commons.collections.MapUtils;

import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Map;

/**
 * 单个请求履历重试
 *
 * @Author: xuchuanhou
 * @Date:2022/4/11下午5:42
 */
@JanusCmdAnnotation(sourceType = "addRequestReplayTask")
public class RequestRetryCmdHandler implements IJanusCmdHandler {

    @Setter
    JanusUploader janusUploader;
    @Setter
    private AccessRecordService accessRecordService;

    @Setter
    private RecordRetryHandler recordRetryHandler;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = sealedMessage.getHeader().getOthers().get("businessTime");
        String recordId = sealedMessage.getHeader().getOthers().get("accessId");
        String retryUseLogStr = sealedMessage.getHeader().getOthers().get("retryUseLog");
        boolean retryResult = false;
        boolean retryUseLog = StringUtils.isNotBlank(retryUseLogStr) && "true".equals(retryUseLogStr);
        AccessRecord record = null;
        if (!retryUseLog) {
            if (sealedMessage.getPayload().getObj() != null) {
                AccessContentDto cont = JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), AccessContentDto.class);
                if (cont != null && MapUtils.isNotEmpty(cont.getRequestHeader())) {
                    record = accessRecordService.getById(recordId, requstTime);
                    record.setAccessContent(cont);
                }
            }
            if (record == null) {
                record = accessRecordService.getRichRecord(recordId, requstTime);
            }
        } else if (sealedMessage.getPayload().getObj() != null) {
            Map map = JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), Map.class);
            String requestMethod = (String) map.get("requestMethod");
            AccessRecord.AccessRecordBuilder builder = AccessRecord.builder().requestMethod(requestMethod);
            Map accessContentMap = (Map) map.get("accessContent");
            AccessContentDto accessContentDto = new AccessContentDto();
            accessContentDto.setRequestHeader((Map<String, String>) accessContentMap.get("requestHeader"));
            accessContentDto.setRequestParam((Map<String, String>) accessContentMap.get("requestParam"));
            if (accessContentMap.get("requestBody") != null) {
                accessContentDto.setRequestBody((String) accessContentMap.get("requestBody"));
            }
            record= builder.build();
            record.setAccessContent(accessContentDto);
        }
        Result<Boolean> result = null;
        if (record == null) {
            result = new Result<Boolean>(Result.ResultCode.FAILED);
            result.setMessage("请求履历为空，无法重推");
        } else {
            if (retryUseLog) {
                retryResult = accessRecordService.retryAccessRecord(record);
            } else if (recordRetryHandler != null) {
                retryResult = recordRetryHandler.retry(record);
            } else {
                retryResult = accessRecordService.retryAccessRecord(recordId, requstTime);
            }
        }
        if (retryResult) {
            result = new Result<>(retryResult, Result.ResultCode.OK);
        } else {
            result = new Result<>(retryResult, Result.ResultCode.FAILED);
        }
        janusUploader.sendJanusCmdResult(sealedMessage.getHeader().getOthers().get("sourceType"), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

//    @Override
//    public String getSourceType() {
//        return "addRequestReplayTask";
//    }
}
