package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.record.domain.AccessContent;

import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.Setter;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/16下午2:49
 */
public class AccessContentRepository {

    @Setter
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;

    @Setter
    private HttpConfig coreConfig;

    public void saveBatch(List<AccessContent> contents) {
        Map<String, Object>[] params = new Map[contents.size()];
        List<Map> rcMaps = BeanMapperUtil.mapList(contents, Map.class);
        rcMaps.toArray(params);

        namedPrmtrJdbcTemplate.batchUpdate(getInsertSql(), params);
    }


    private String getInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(AccessContent.getTableNameBySharding(coreConfig.getAccess().getShardType())).append("(");
        builder.append(
                "id,content").append(")values(");
        builder.append(
                ":id,:content").append(")");

        return builder.toString();
    }

    //TODO
    private static final String queryByIdSql = "select id,content from %s where id=:id";

    public AccessContent getById(String id, String yyyyMMdd) {
        String tableName = StringUtils.isBlank(yyyyMMdd) ? AccessContent.getTableNameBySharding(coreConfig.getAccess().getShardType()) : AccessContent.getTableName(yyyyMMdd);

        String querySql = String.format(queryByIdSql, tableName);
        Map<String, Object> param = new HashMap<String, Object>() {{
            put("id", id);
        }};
        AccessContent acc = null;
        try {
            acc = namedPrmtrJdbcTemplate.queryForObject(querySql, param, new RowMapper<AccessContent>() {
                @Override
                public AccessContent mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessContent accessContent = new AccessContent(
                            rs.getString("id"),
                            rs.getString("content")
                    );

                    return accessContent;
                }
            });
        } catch (EmptyResultDataAccessException ex) {

        }
        return acc;
    }


}
