package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.config.core.config.AccessConfig;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.util.PageUtils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.Setter;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/16下午2:49
 */
public class AccessRecordRepository {

    @Setter
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;

    @Setter
    private HttpConfig httpConfig;

    public void saveBatch(List<AccessRecord> records) {
        Map<String, Object>[] params = new Map[records.size()];
        List<Map> rcMaps = BeanMapperUtil.mapList(records, Map.class);

        rcMaps.toArray(params);
        namedPrmtrJdbcTemplate.batchUpdate(getInsertSql(), params);
    }


    private String getInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(AccessRecord.getTableNameBySharding(httpConfig.getAccess().getShardType())).append("(");
        builder.append(
                "id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len").append(")values(");
        builder.append(
                ":id,:requestMethod,:clientProjectId,:serverProjectId,:apiId,:action,:costTime,:status,:contentId,:traceId,:serialNo,:sourceIp,:requestTime,:reqDataLen,:repDataLen").append(")");

        return builder.toString();
    }

    private static final String QUERYSQL = "select id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len from %s where 1=1 ";
    private static final String queryByIdSql = QUERYSQL + " and  id=:id";

    private static final String QUERYCOUNTSQL = "select count(1) from %s where 1=1";


    public AccessRecord getById(String id, String yyyyMMdd) {
        String tableName = StringUtils.isBlank(yyyyMMdd) ? AccessRecord.getTableNameBySharding(httpConfig.getAccess().getShardType()) : AccessRecord.getTableName(yyyyMMdd);

        String querySql = String.format(queryByIdSql, tableName);
        Map<String, Object> param = new HashMap<String, Object>() {{
            put("id", id);
        }};
        AccessRecord acc =null;

        try {
            acc = namedPrmtrJdbcTemplate.queryForObject(querySql, param, new RowMapper<AccessRecord>() {
                @Override
                public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                    builder.id(rs.getString("id"))
                            .requestMethod(rs.getString("request_method"))
                            .action(rs.getString("action"))
                            .apiId(rs.getString("api_id"))
                            .traceId(rs.getString("trace_id"))
                            .reqDataLen(rs.getInt("req_data_len"))
                            .repDataLen(rs.getInt("rep_data_len"))
                            .serialNo(rs.getString("serial_no"))
                            .requestTime(rs.getString("request_time"))
                            .sourceIp(rs.getString("source_ip"))
                            .contentId(rs.getString("content_id"))
                            .status(rs.getInt("status"))
                            .clientProjectId(rs.getString("client_project_id"))
                            .serverProjectId(rs.getString("server_project_id"))
                            .costTime(rs.getLong("cost_time"))
                    ;

                    return builder.build();
                }
            });
        }catch (EmptyResultDataAccessException ex){

        }
        return acc;
    }

    public PageUtils queryForPage(RecordPageParam param) {
        String yyyyMMd = param.getRequestTime().replaceAll("-", "").substring(0, 8);
        if(AccessConfig.SHARDING_YEAR.equals(httpConfig.getAccess().getShardType())){
            yyyyMMd=yyyyMMd.substring(0,4);
        }else if(AccessConfig.SHARDING_MONTH.equals(httpConfig.getAccess().getShardType())){
            yyyyMMd=yyyyMMd.substring(0,6);
        }

        String tableName = StringUtils.isBlank(yyyyMMd) ? AccessRecord.getTableNameBySharding(httpConfig.getAccess().getShardType()) : AccessRecord.getTableName(yyyyMMd);

        String querySql = String.format(QUERYSQL, tableName);
        String queryCountSql = String.format(QUERYCOUNTSQL, tableName);

        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(param.getAction())) {
            querySql += " and action=:action";
            queryCountSql+= " and action=:action";
            params.put("action", param.getAction());

        }

        if (StringUtils.isNotBlank(param.getSerialNo())) {
            if(!param.getIsLike()){
                querySql += " and serial_no=:serialNo";
                queryCountSql += " and serial_no=:serialNo";
                params.put("serialNo", param.getSerialNo());
            }else{
                //模糊匹配
                querySql += " and serial_no like concat(:serialNo,'%')";
                queryCountSql += " and serial_no like concat(:serialNo,'%')";
                params.put("serialNo", param.getSerialNo());
            }

        }

        if (StringUtils.isNotBlank(param.getStatus()) &&!RecordPageParam.STATUS_ALL.equals( param.getStatus())) {
            querySql += " and status=:status";
            queryCountSql += " and status=:status";
            params.put("status",param.getStatus());
        }

       Integer rows =  namedPrmtrJdbcTemplate.queryForObject(queryCountSql,params,Integer.class);

        List<AccessRecord> accs =null;
        if(rows>0){
            if(param.getPage()<=1){
                querySql+=" limit 0,"+param.getSize();
            }else{
                querySql+=" limit "+((param.getPage()-1)*param.getSize())+","+param.getSize();
            }

            accs= namedPrmtrJdbcTemplate.query(querySql, params, new RowMapper<AccessRecord>() {
                @Override
                public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                    builder.id(rs.getString("id"))
                            .requestMethod(rs.getString("request_method"))
                            .action(rs.getString("action"))
                            .apiId(rs.getString("api_id"))
                            .traceId(rs.getString("trace_id"))
                            .reqDataLen(rs.getInt("req_data_len"))
                            .repDataLen(rs.getInt("rep_data_len"))
                            .serialNo(rs.getString("serial_no"))
                            .requestTime(rs.getString("request_time"))
                            .sourceIp(rs.getString("source_ip"))
                            .contentId(rs.getString("content_id"))
                            .status(rs.getInt("status"))
                            .clientProjectId(rs.getString("client_project_id"))
                            .serverProjectId(rs.getString("server_project_id"))
                            .costTime(rs.getLong("cost_time"))
                    ;
                    return builder.build();
                }
            });
        }
        PageUtils pageUtils = new PageUtils(accs, rows, param.getSize(), param.getPage());
        return pageUtils;

    }

}
