package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.utils.Base64Util;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.code.GZipUtils;

import org.apache.http.HttpStatus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/27下午2:09
 */
public class HttpUitls {

    private static final int SPLIT_SIZE = 515000;

    /**集成大报文压缩*/
    public static HttpUtil.ResponseCus doPostJsonEntire(String url, String json, Map<String, String> headers, Map<String, Object> params) throws IOException {

        if (headers == null) {
            headers = new HashMap<>();
        }

        if (json.length() < SPLIT_SIZE) {
            return HttpUtil.doPostJsonEntire(url, json, headers, params);
        }

        headers.put("Content-Encoding", "gzip");
        byte[] btmp = GZipUtils.gzip(json);
        if (btmp.length < SPLIT_SIZE) {
            return HttpUtil.doPostJsonEntire(url, new String(btmp), headers, params);
        }

        btmp = Base64Util.encode(btmp);
        int eachSize = SPLIT_SIZE;

        int mod = btmp.length % eachSize;
        int count = mod == 0 ? btmp.length / eachSize : (btmp.length / eachSize) + 1;
        HttpUtil.ResponseCus resp = null;
        String taskId = UniqIdUtils.getInstance().getUniqID();
        for (int i = 0; i < count; i++) {

            byte[] des = null;
            if (mod == 0 || i < count - 1) {
                des = new byte[eachSize];
                System.arraycopy(btmp, eachSize * i, des, 0, eachSize);
            } else {
                des = new byte[mod];
                System.arraycopy(btmp, eachSize * i, des, 0, mod);
            }

            headers.put("big-data-split-task-id", taskId);
            headers.put("big-data-split-task-id", taskId);
            headers.put("big-data-split-index", "" + i);
            headers.put("big-data-split-count", "" + count);
            headers.put("Content-Type", "application/json");
            try {
                resp = doPostJsonEntire(url, new String(des), headers, params);
                if (i == count - 1) {
                    return resp;
                } else if (resp.getStatus() != HttpStatus.SC_OK) {
                    //重试一次
                    resp = doPostJsonEntire(url, new String(des), headers, params);
                }
            } catch (IOException e) {
            }
        }

        return resp;
    }

}
