package com.xforceplus.janus.framework.dto;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;

@Data
public class LogFileDescribeCacheDto {
    //不会变化的日志文件 key 日期yyyy-mm-dd    value  日志路径
    private Map<String, List<LogFileDescribeDto>> dateFileMap = new HashMap<>(16);

    // key 日志目录下日志文件全路径  , 可以用于查询的日志文件描述对象
    private Map<String, LogFileDescribeDto> logFileMap = new HashMap<>(16);
    private Map<String, String> dec2SrcMap = new HashMap<>(16);

    public List<LogFileDescribeDto> listLogFileByDateTime(String day) {
        return dateFileMap.get(day);
    }

    public LogFileDescribeDto getTargetFile(String fileFullPath) {
        return logFileMap.get(fileFullPath);
    }

    public Map<String, LogFileDescribeDto> getlogFileMap() {
        return logFileMap;
    }

    public LogFileDescribeDto putTargetFile(String fileFullPath, LogFileDescribeDto logFileDescribeDto) {
        logFileMap.put(fileFullPath, logFileDescribeDto);
        dec2SrcMap.put(logFileDescribeDto.getLogFileFullPath(), fileFullPath);
        List<String> dateTimes = logFileDescribeDto.getDateTimes();
        if (CollectionUtils.isNotEmpty(dateTimes)) {
            for (String dateTime : dateTimes) {
                List<LogFileDescribeDto> files = dateFileMap.get(dateTime);
                if (CollectionUtils.isEmpty(files)) {
                    files = new ArrayList<>();
                }
                boolean cantain = false;
                for (LogFileDescribeDto dto : files) {
                    if (dto.getLogFileFullPath().equals(logFileDescribeDto)) {
                        cantain = true;
                        break;
                    }
                }
                if (!cantain) {
                    files.add(logFileDescribeDto);
                    Collections.sort(files, (LogFileDescribeDto file1, LogFileDescribeDto file2) -> {
                        try {
                            long creationTime1 = file1.getCreationTime();
                            long lastModifiedTime1 = file1.getLastModifiedTime();
                            long creationTime2 = file1.getCreationTime();
                            long lastModifiedTime2 = file1.getLastModifiedTime();
                            if (lastModifiedTime2 != lastModifiedTime1) {
                                return lastModifiedTime2 - lastModifiedTime1 > 0 ? -1 : 1;
                            } else if (creationTime2 != creationTime1) {
                                return creationTime2 - creationTime1 > 0 ? -1 : 1;
                            } else {
                                return file2.getLogFileFullPath().compareTo(file1.getLogFileFullPath());
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        return file2.getLogFileFullPath().compareTo(file1.getLogFileFullPath());
                    });
                }
                dateFileMap.put(dateTime, files);
            }
        }
        return logFileDescribeDto;
    }
}
