package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.msg.SealedMessage;

import org.springframework.context.ApplicationEventPublisher;

import lombok.extern.slf4j.Slf4j;

@Slf4j
 public class InternalListener implements IMessageListener {

    private ApplicationEventPublisher eventPublisher;

    public  InternalListener(ApplicationEventPublisher eventPublisher){
        this.eventPublisher= eventPublisher;
    }

    @Override
    public boolean onMessage(SealedMessage sealedMessage) {
        SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this,sealedMessage);

        eventPublisher.publishEvent(sealedMessageEvent);
        log.info("业务代码:{} ID:{}:事件发送完成",sealedMessage.getHeader().getPayLoadId(),sealedMessage.getHeader().getMsgId());
        return true;
    }
}
