package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.dto.ClientInfo;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/9下午4:59
 */
@Slf4j
@Order(0)
public class ProjectClientInitHandler implements ConfigHandler {

    @Setter
    private InternalListener messageListener;
    @Setter
    private HttpConfig httpConfig;

    @Override
    public void doHandler(String body) {
        try {
            if (StringUtils.isNotBlank(body) && MCFactory.getInstance() != null) {
            }
        } catch (RuntimeException ex) {
            //MCFactory 为空才创建
            ClientInfo clientInfo = JacksonUtil.getInstance().fromJson(body, ClientInfo.class);
            MCFactory mcFactory = null;
            if (httpConfig != null && StringUtils.isNotBlank(httpConfig.getTcpProxyHost())) {
                mcFactory = MCFactory.getInstance(clientInfo.getClientId(), httpConfig.getTcpProxyHost(), httpConfig.getTcpProxyPort());
            } else {
                mcFactory = MCFactory.getInstance(clientInfo.getClientId(), clientInfo.getUrl(), clientInfo.getPort());
            }
            mcFactory.registerListener(messageListener);
            /**从集成框架接入-关闭自动ack功能*/
            mcFactory.setAutoAck(false);
            return;
        }

    }

    @Override
    public String getConfigKey() {
        return "client";
    }
}
