package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.msg.SealedMessage;
import lombok.Data;
import org.springframework.context.ApplicationEvent;

@Data
public class SealedMessageEvent extends ApplicationEvent {

    private String requestName;

    private SealedMessage sealedMessage;

    public SealedMessageEvent(Object source, SealedMessage sealedMessage) {
        super(source);
        this.sealedMessage = sealedMessage;
        this.requestName = sealedMessage.getHeader().getRequestName();
    }
}
