package com.xforceplus.janus.framework.record.domain;

import com.xforceplus.janus.config.core.config.AccessConfig;

import org.apache.commons.lang3.time.DateFormatUtils;

import lombok.Builder;
import lombok.Data;

/**
 * 请求履历
 *
 * @Date:2022/2/19下午4:04
 */
@Data
@Builder
public class AccessRecord {
    public static final String TABLE_NAME = "t_janus_access_record";

    private String id;
    private String requestMethod;

    //调用方项目ID
    private String clientProjectId;
    //服务提供方项目ID
    private String serverProjectId;
    private String apiId;
    // 集成平台授权action或者接口路径
    private String action;
    /**完整请求存存储的ID 表的ID/OSSKey/fileId */
    private String contentId;
    private int status;
    /**耗时 ,单位毫秒*/
    private Long costTime;
    /**序列号 一次请求的唯一标识号，请求、响应一致*/
    private String traceId;
    /**流水号*/
    private String serialNo;
    private String sourceIp;
    private String requestTime;


    /**请求体数据长度byte*/
    private Integer reqDataLen;
    /**响应数据长度byte*/
    private Integer repDataLen;

    private AccessContentDto accessContent;

    public static String getTableName() {
        return TABLE_NAME + "_" + DateFormatUtils.format(System.currentTimeMillis(), "yyyyMMdd");
    }


    public static String getTableNameBySharding(String type) {
        if(AccessConfig.SHARDING_YEAR.equals(type)){
            return TABLE_NAME + "_" + DateFormatUtils.format(System.currentTimeMillis(), "yyyy");
        }else if(AccessConfig.SHARDING_MONTH.equals(type)){
            return TABLE_NAME + "_" + DateFormatUtils.format(System.currentTimeMillis(), "yyyyMM");
        }else{
            return TABLE_NAME + "_" + DateFormatUtils.format(System.currentTimeMillis(), "yyyyMMdd");
        }
    }
    public static String getTableName(String yyyMMdd) {
        return TABLE_NAME + "_" + yyyMMdd;
    }

}
