package com.xforceplus.janus.framework.record.init;


import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.record.portal.AccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.RestUrlUploader;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.CommandLineRunner;

import java.util.List;
import java.util.Map;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/6下午7:36
 */
@Slf4j
public class AccessRecordConsumerInit implements CommandLineRunner {

    @Setter
    private AccessRecordConsumer accessRecordConsumer;

    @Setter
    private RestUrlUploader restUrlUploader;
    @Setter
    private HttpConfig httpConfig;

    @Setter
    private JanusUploader janusUploader;


    @Override
    public void run(String... args) throws Exception {
        accessRecordConsumer.start();

        /**自动上报系统自带的API*/
        if(httpConfig.isUploadApi()){
            List<Map<String, String>> urls = restUrlUploader.getUrl();
            if (CollectionUtils.isNotEmpty(urls)) {
                new Thread(() -> {
                    synchronized (httpConfig) {
                            janusUploader.sendJanusCmdResult("uploadApis", "1", urls);
                    }
                }).start();
            }
        }

    }
}
