package com.xforceplus.janus.framework.record.init;


import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.dto.ApiDto;
import com.xforceplus.janus.config.core.dto.ProjectDto;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;


/**
 * 数据库表同步配置,根据配置中心同步配置启动同步线程进行数据同步<br/> 如果该配置没有被调用(云端无配置)，需要执行本地扫描本地数据库读取配置信息 <br/> 最早执行
 *
 * @param
 * @author xucuanhou
 * @return
 * @date 2021/12/28
 */
@Slf4j
@Order(0)
public class ProjectCacheHandler implements ConfigHandler {

    /**
     * key:path+method
     */
    @Getter
    private Map<String, ApiDto> apiCache = new ConcurrentHashMap<>();

    @Getter
    private Map<String, String> httpDiyFlowCache = new ConcurrentHashMap<>();

    @Override
    public String getConfigKey() {
        return "projectInfo";
    }

    @Override
    public void doHandler(String body) {
        if (StringUtils.isNotBlank(body)) {
            ProjectDto projectDto = JacksonUtil.getInstance().fromJson(body, ProjectDto.class);
            synchronized (apiCache) {
                apiCache.clear();
                if (projectDto != null && CollectionUtils.isNotEmpty(projectDto.getApisEntities())) {
                    projectDto.getApisEntities().forEach(api -> {
                        apiCache.put(api.getRequestPath() + api.getRequestMethod(), api);
                    });
                }
            }
        }
    }

    @Override
    public void nullValueHandler() {
    }

}