/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.cmd;

import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.IOUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.LogFileDescribeCacheDto;
import com.xforceplus.janus.framework.dto.LogFileDescribeDto;
import com.xforceplus.janus.framework.record.cache.SysCmdCache;
import com.xforceplus.janus.framework.record.domain.LocalClusterLogQuery;
import com.xforceplus.janus.framework.util.DateUtils;
import com.xforceplus.janus.framework.util.FileCmdCache;
import com.xforceplus.janus.framework.util.IPUtils;
import com.xforceplus.janus.framework.util.MyFileUtils;
import com.xforceplus.janus.framework.util.ThreadPoolCmdUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.system.ApplicationHome;

@JanusCmdAnnotation(sourceType="executeSysCmd")
public class SysCmdHandler
implements IJanusCmdHandler,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SysCmdHandler.class);
    private JanusUploader janusUploader;
    private static final int cmd_response_max = 500000;
    private static final int cmd_response_max_line = 200;
    private static final boolean testEnable = false;
    private static final int size = 5;
    private static final BlockingQueue<SealedMessage> tasks = new ArrayBlockingQueue<SealedMessage>(5);
    private HttpConfig httpConfig;
    private Set<String> forbidCmds = new HashSet<String>(){
        {
            this.add("rm ");
            this.add("rmdir ");
            this.add("-delete");
            this.add("awk ");
            this.add("rmdir ");
        }
    };
    private String allowCmdPattern = "^(ls|cd|grep|cat|zcat|pwd).*";
    Pattern pattern = Pattern.compile(this.allowCmdPattern);
    private static final String log_folder = "logs";
    private static final String no_zip_log_folder = "unZipLogs";
    private volatile LogFileDescribeCacheDto logFileDescribeCache = new LogFileDescribeCacheDto();
    private volatile List<String> address = new LinkedList<String>();
    private String osName = "";
    private final String Windows = "Windows";
    private final String Linux = "Linux";
    private final String noSupport = "noSupport";

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        if (!this.httpConfig.isRemoteLog()) {
            return;
        }
        log.debug(JacksonUtil.getInstance().toJson((Object)sealedMessage));
        String os_name = this.loadOsName();
        if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
            log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
            String errorMsg = "\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2";
            this.sendError(sealedMessage, errorMsg);
            return;
        }
        if (!tasks.offer(sealedMessage)) {
            String errorMsg = "\u5f85\u6267\u884c\u7684\u67e5\u8be2\u65e5\u5fd7\u6307\u4ee4\u5df2\u8d85\u8fc75\u6761";
            this.sendError(sealedMessage, errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandlerSealedMessage(SealedMessage sealedMessage) {
        long start = System.currentTimeMillis();
        try {
            String errorMsg;
            String ipAddress;
            int index = 0;
            int limit = 0;
            String startTime = (String)sealedMessage.getHeader().getOthers().get("startTime");
            String endTime = (String)sealedMessage.getHeader().getOthers().get("endTime");
            String indexStr = (String)sealedMessage.getHeader().getOthers().get("index");
            String logFileName = (String)sealedMessage.getHeader().getOthers().get("logFileName");
            String limitStr = (String)sealedMessage.getHeader().getOthers().get("limit");
            String keyWords = (String)sealedMessage.getHeader().getOthers().get("keyWords");
            String logContent = (String)sealedMessage.getHeader().getOthers().get("logContent");
            String logLocation = (String)sealedMessage.getHeader().getOthers().get("logLocation");
            String getLogsDir = (String)sealedMessage.getHeader().getOthers().get("getLogsDir");
            if (StringUtils.isNotBlank((CharSequence)getLogsDir) && getLogsDir.equalsIgnoreCase("yes")) {
                this.sendError(sealedMessage, JacksonUtil.getInstance().toJson((Object)this.logFileDescribeCache));
                return;
            }
            if (StringUtils.isBlank((CharSequence)logLocation)) {
                logLocation = "self";
            }
            boolean onlyQueryRecord = false;
            if (StringUtils.isNotBlank((CharSequence)logContent) && "true".equals(logContent)) {
                onlyQueryRecord = true;
            }
            if (StringUtils.isBlank((CharSequence)keyWords)) {
                throw new IllegalArgumentException("\u67e5\u8be2\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isBlank((CharSequence)endTime)) {
                throw new IllegalArgumentException("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isBlank((CharSequence)endTime)) {
                startTime = endTime;
            }
            if (startTime.length() != 19 && startTime.length() != 16 && startTime.length() != 13 && startTime.length() != 10) {
                throw new IllegalArgumentException("\u67e5\u8be2\u65f6\u95f4\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss,yyyy-MM-dd HH:mm,yyyy-MM-dd HH,yyyy-MM-dd");
            }
            if (StringUtils.isNotBlank((CharSequence)indexStr)) {
                index = Integer.valueOf(indexStr);
            }
            if (index < 0) {
                index = 0;
            }
            if (StringUtils.isNotBlank((CharSequence)limitStr)) {
                limit = Integer.valueOf(limitStr);
            }
            if (limit <= 0 || limit > 500000) {
                limit = 500000;
            }
            String string = ipAddress = this.address == null || this.address.size() == 0 ? "" : String.join((CharSequence)",", this.address);
            if (!logLocation.equals("self")) {
                String uuid = UniqIdUtils.getInstance().getUniqID();
                LocalClusterLogQuery localClusterLogQuery = new LocalClusterLogQuery();
                localClusterLogQuery.setStartTime(startTime);
                localClusterLogQuery.setEndTime(endTime);
                localClusterLogQuery.setIndex(index + "");
                localClusterLogQuery.setLimit(limit + "");
                localClusterLogQuery.setLogFileName(logFileName);
                localClusterLogQuery.setKeyWords(keyWords);
                localClusterLogQuery.setLogLocation(logLocation);
                localClusterLogQuery.setLogContent(logContent);
                localClusterLogQuery.setTimeStamp(System.currentTimeMillis() + "");
                localClusterLogQuery.setIpAddress(ipAddress);
                localClusterLogQuery.setUuid(uuid);
                localClusterLogQuery.setSourceType((String)sealedMessage.getHeader().getOthers().get("sourceType"));
                localClusterLogQuery.setCmdSerialKey((String)sealedMessage.getHeader().getOthers().get("cmdSerialKey"));
                SysCmdCache.put(localClusterLogQuery);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("logFileName", "");
                resultMap.put("readStatus", "false");
                resultMap.put("readResult", "\u7b49\u5f85\u5c5e\u5730\u5b50\u9879\u76ee\u67e5\u8be2\u65e5\u5fd7");
                resultMap.put("uuid", uuid);
                resultMap.put("ipAddress", ipAddress);
                resultMap.put("readInx", "0");
                resultMap.put("totalLength", "");
                this.sendSucc(resultMap, sealedMessage);
                return;
            }
            String startDay = startTime.substring(0, 10);
            List<LogFileDescribeDto> files1 = this.logFileDescribeCache.listLogFileByDateTime(startDay);
            int fileListNotLoaded = CollectionUtils.isEmpty(files1) ? 0 : files1.size();
            log.info("fileListNotLoaded: {} ", (Object)startDay, (Object)fileListNotLoaded);
            if (fileListNotLoaded <= 0) {
                errorMsg = "\u8fd8\u672a\u8bfb\u53d6\u5230\u65e5\u5fd7\u6587\u4ef6\u5217\u8868," + this.getLogsDir();
                this.sendError(sealedMessage, errorMsg);
            } else if (this.searchFile(sealedMessage, index, limit, startTime, logFileName, keyWords, files1, onlyQueryRecord)) {
                return;
            }
            errorMsg = "\u6ca1\u6709\u67e5\u8be2\u5230\u65e5\u5fd7";
            this.sendError(sealedMessage, errorMsg);
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            String errorMsg = "\u67e5\u8be2\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38";
            this.sendError(sealedMessage, errorMsg);
        }
        finally {
            log.info("doHandlerSealedMessage costTime : {}", (Object)(System.currentTimeMillis() - start));
        }
    }

    private boolean searchFile(SealedMessage sealedMessage, int index, int limit, String startTime, String logFileName, String keyWords, List<LogFileDescribeDto> files1, boolean onlyQueryRecord) {
        try {
            LogFileDescribeDto logFileDescribeDto;
            String src;
            if (CollectionUtils.isEmpty(files1)) {
                return false;
            }
            List<Object> searchFiles = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)logFileName) && StringUtils.isNotBlank((CharSequence)(src = this.logFileDescribeCache.getDec2SrcMap().get(logFileName))) && (logFileDescribeDto = this.logFileDescribeCache.getlogFileMap().get(src)) != null) {
                searchFiles = files1.stream().filter(e -> {
                    if (e.getLogFileFullPath().compareTo(logFileDescribeDto.getLogFileFullPath()) == 0) {
                        return true;
                    }
                    if (e.getLastModifiedTime() - logFileDescribeDto.getLastModifiedTime() <= 0L) {
                        return true;
                    }
                    return e.getCreationTime() - logFileDescribeDto.getCreationTime() <= 0L;
                }).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(searchFiles)) {
                searchFiles = files1;
            }
            for (int i = 0; i < searchFiles.size(); ++i) {
                if (i != searchFiles.size() - 1 && i % 3 != 2 || !this.searchFileOnePage(sealedMessage, index, limit, startTime, logFileName, keyWords, onlyQueryRecord, searchFiles)) continue;
                return true;
            }
        }
        catch (Exception e2) {
            log.error("userIndex error {}", (Object)ErrorUtil.getStackMsg((Exception)e2));
        }
        return false;
    }

    private boolean searchFileOnePage(SealedMessage sealedMessage, int index, int limit, String startTime, String logFileName, String keyWords, boolean onlyQueryRecord, List<LogFileDescribeDto> searchFiles) {
        ArrayList<FutureTask<Map>> tasks = new ArrayList<FutureTask<Map>>();
        if (CollectionUtils.isNotEmpty(searchFiles)) {
            for (LogFileDescribeDto logFileDescribeDto : searchFiles) {
                String string = logFileDescribeDto.getLogFileFullPath();
                String cmd = this.getCmd(startTime, keyWords, string, onlyQueryRecord);
                Integer size = (Integer)FileCmdCache.get(cmd);
                boolean cache = logFileDescribeDto.getChangeFlag() == 2 && size == null;
                int finalLimit = limit;
                if (size != null && size <= 0) continue;
                Callable<Map> callable = () -> this.doCmd(cmd, fileName, cache, 0, finalLimit);
                FutureTask<Map> task = new FutureTask<Map>(callable);
                tasks.add(task);
            }
        }
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (FutureTask futureTask : tasks) {
                ThreadPoolCmdUtils.execute(futureTask);
            }
        }
        HashMap resultMap = new HashMap();
        for (FutureTask futureTask : tasks) {
            try {
                Map cmdResultMap = (Map)futureTask.get();
                if (!"true".equals(cmdResultMap.get("readStatus"))) continue;
                resultMap.put(cmdResultMap.get("logFileName"), cmdResultMap);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException[{}]", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("ExecutionException[{}]", (Throwable)e);
            }
            catch (Exception e) {
                log.error("exception[{}]", (Throwable)e);
            }
            catch (Error e) {
                log.error("exception[{}]", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(searchFiles)) {
            for (LogFileDescribeDto logFileDescribeDto : searchFiles) {
                String fileName;
                Map cmdResultMap = (Map)resultMap.get(fileName = logFileDescribeDto.getLogFileFullPath());
                log.info("fileName: {} ,{} ", (Object)fileName, (Object)(cmdResultMap != null && "true".equals(cmdResultMap.get("readStatus")) ? 1 : 0));
                if (cmdResultMap == null || !"true".equals(cmdResultMap.get("readStatus"))) continue;
                log.info("send1Succ {}", (Object)fileName);
                this.sendSucc(cmdResultMap, sealedMessage);
                return true;
            }
        }
        return false;
    }

    private void sendError(SealedMessage sealedMessage, String errorMsg) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("readStatus", "false");
        result.put("readResult", errorMsg);
        result.put("readInx", "0");
        result.put("totalLength", "0");
        result.put("logFileName", "");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("message", "FAILED");
        resultMap.put("executeSysCmd", "executeSysCmd");
        resultMap.put("result", result);
        this.sendMsg(resultMap, sealedMessage);
    }

    private void sendSucc(Map<String, String> result, SealedMessage sealedMessage) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "1");
        resultMap.put("message", "FINISHED");
        resultMap.put("executeSysCmd", "executeSysCmd");
        resultMap.put("result", result);
        this.sendMsg(resultMap, sealedMessage);
    }

    private void sendMsg(Map<String, Object> resultMap, SealedMessage sealedMessage) {
        String resultstr = JacksonUtil.getInstance().toJson(resultMap);
        this.janusUploader.sendJanusCmdResult((String)sealedMessage.getHeader().getOthers().get("sourceType"), (String)sealedMessage.getHeader().getOthers().get("cmdSerialKey"), (Object)resultstr);
    }

    private String getCmd(String startTime, String keyWords, String fileName, boolean onlyQueryRecord) {
        String os_name = this.loadOsName();
        if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
            log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (os_name.equals("Linux")) {
            if (fileName.endsWith(".gz")) {
                sb.append("zcat ").append(fileName).append(" | grep  '").append(startTime).append("' ");
                this.buildLinuxKeyWords(keyWords, sb);
            } else {
                sb.append("cat ").append(fileName).append(" | grep  '").append(startTime).append("' ");
                this.buildLinuxKeyWords(keyWords, sb);
            }
            sb.append("  | grep  -v 'com.xforceplus.janus.framework.cmd.SysCmdHandler' ").append("  | grep  -v 'executeSysCmd' ");
            if (onlyQueryRecord) {
                sb.append("  | grep  'com.xforceplus.janus.framework.record.portal.LogAccessRecordConsumer' ").append("  | grep  -v 'com.xforceplus.janus.config.core.monitor.JanusUploader'");
            }
        } else if (os_name.equals("Windows")) {
            sb.append("cmd /c   ").append(" find  \"").append(startTime).append("\"  ").append(fileName);
            this.buildWindowsKeyWords(keyWords, sb);
            sb.append("  | find  /v \"com.xforceplus.janus.framework.cmd.SysCmdHandler\" ").append("  | find  /v \"executeSysCmd\" ");
            if (onlyQueryRecord) {
                sb.append("  | find  \"com.xforceplus.janus.framework.record.portal.LogAccessRecordConsumer\"  ").append("  | find  /v \" com.xforceplus.janus.config.core.monitor.JanusUploader\" ");
            }
        }
        return sb.toString();
    }

    private void buildLinuxKeyWords(String keyWords, StringBuilder sb) {
        if (keyWords.contains(",")) {
            String[] splits;
            for (String split : splits = keyWords.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)split)) continue;
                sb.append(" | grep  '").append(split.trim()).append("' -A2 ");
            }
        } else {
            sb.append(" | grep  '").append(keyWords.trim()).append("' -A2 ");
        }
    }

    private void buildWindowsKeyWords(String keyWords, StringBuilder sb) {
        if (keyWords.contains(",")) {
            String[] splits;
            for (String split : splits = keyWords.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)split)) continue;
                sb.append(" | find  \"").append(split.trim()).append("\" ");
            }
        } else {
            sb.append(" | find  \"").append(keyWords.trim()).append("\"  ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map<String, String> doCmd(String cmd, String fileName, boolean cache, int index, int limit) {
        resultMap = new HashMap<String, String>();
        try {
            block41: {
                SysCmdHandler.log.info("CmdPrint10 {},cmd:{},cache:{}", new Object[]{fileName, cmd, cache});
                resultMap.put("logFileName", fileName);
                cmdResponse = new StringBuilder();
                process = null;
                bufferedReader = null;
                errorReader = null;
                LastLength = 0;
                length = 0;
                try {
                    os_name = this.loadOsName();
                    if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
                        SysCmdHandler.log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                        throw new IllegalArgumentException("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                    }
                    if (os_name.equals("Linux")) {
                        process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        var14_18 = process.waitFor(4L, TimeUnit.SECONDS);
                    } else if (os_name.equals("Windows")) {
                        process = Runtime.getRuntime().exec(cmd);
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        var14_18 = process.waitFor(4L, TimeUnit.SECONDS);
                    } else {
                        SysCmdHandler.log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                        throw new IllegalArgumentException("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                    }
                    cont = null;
                    line = 0;
                    full = false;
                    readInx = index;
                    while ((cont = bufferedReader.readLine()) != null) {
                        LastLength = length;
                        if (!full && index < (length += cont.length())) {
                            if (index >= LastLength) {
                                subString = cont.substring(index - LastLength);
                                if (StringUtils.isNotBlank((CharSequence)subString)) {
                                    if (subString.length() < limit - cmdResponse.length()) {
                                        cmdResponse.append(subString).append("\n\r");
                                    } else {
                                        cmdResponse.append(subString.substring(0, limit - cmdResponse.length())).append("\n\r");
                                    }
                                }
                            } else if (StringUtils.isNotBlank((CharSequence)cont)) {
                                if (cont.length() < limit - cmdResponse.length()) {
                                    cmdResponse.append(cont).append("\n\r");
                                } else {
                                    cmdResponse.append(cont.substring(0, limit - cmdResponse.length())).append("\n\r");
                                }
                            }
                            readInx = length;
                        }
                        if (cmdResponse.length() >= limit) {
                            full = true;
                            if (!cache) break;
                        }
                        if (line > 200) {
                            full = true;
                            if (!cache) break;
                        }
                        ++line;
                    }
                    resultMap.put("readInx", "" + readInx);
                    errorLine = null;
                    if (cmdResponse.length() <= 0) {
                        while ((errorLine = errorReader.readLine()) != null) {
                            cmdResponse.append(errorLine).append("\n\r");
                        }
                        if (cmdResponse.length() >= 0) {
                            resultMap.put("readStatus", "false");
                            resultMap.put("readResult", "");
                            SysCmdHandler.log.error("cmd:{}  run error,{}", (Object)cmd, (Object)cmdResponse);
                        }
                    } else {
                        resultMap.put("readResult", cmdResponse.toString());
                        resultMap.put("readStatus", "true");
                    }
                    if (errorReader == null) break block41;
                }
                catch (Exception exception) {
                    block42: {
                        SysCmdHandler.log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Exception)exception));
                        resultMap.put("readStatus", "false");
                        resultMap.put("readResult", "");
                        if (errorReader == null) break block42;
                        IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                    }
                    if (bufferedReader != null) {
                        IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Error Error) {
                    block43: {
                        SysCmdHandler.log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Throwable)Error));
                        resultMap.put("readStatus", "false");
                        resultMap.put("readResult", "");
                        if (errorReader == null) break block43;
                        {
                            catch (Throwable var19_24) {
                                if (errorReader != null) {
                                    IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                                }
                                if (bufferedReader != null) {
                                    IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                                }
                                if (process != null) {
                                    process.destroy();
                                }
                                throw var19_24;
                            }
                        }
                        IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                    }
                    if (bufferedReader != null) {
                        IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                    }
                    if (process != null) {
                        process.destroy();
                    } else {
                        ** GOTO lbl129
                    }
                }
                IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
            }
            if (bufferedReader != null) {
                IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
            }
            if (process != null) {
                process.destroy();
            }
            if (resultMap.get("readStatus") == null || "false".equals(resultMap.get("readStatus"))) {
                resultMap.put("readInx", "" + index);
                length = 0;
            }
            if (cache) {
                FileCmdCache.set(cmd, length, 86400000L);
            }
            resultMap.put("totalLength", "" + length);
            return resultMap;
        }
        catch (Exception e) {
            SysCmdHandler.log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error er) {
            SysCmdHandler.log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Throwable)er));
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String doCmd(String cmd) {
        String cont;
        block19: {
            cont = "";
            try {
                BufferedReader bufferedReader;
                Process process;
                block18: {
                    log.info("testEnable cmd:{}", (Object)cmd);
                    process = null;
                    bufferedReader = null;
                    BufferedReader errorReader = null;
                    try {
                        process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        boolean proresult = process.waitFor(4L, TimeUnit.SECONDS);
                        cont = bufferedReader.readLine();
                        if (errorReader == null) break block18;
                    }
                    catch (Exception exception) {
                        block20: {
                            log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Exception)exception));
                            if (errorReader == null) break block20;
                            IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                        }
                        if (bufferedReader != null) {
                            IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                        }
                        if (process != null) {
                            process.destroy();
                        }
                        break block19;
                    }
                    catch (Error Error2) {
                        block21: {
                            log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Throwable)Error2));
                            if (errorReader == null) break block21;
                            {
                                catch (Throwable throwable) {
                                    if (errorReader != null) {
                                        IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                                    }
                                    if (bufferedReader != null) {
                                        IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                                    }
                                    if (process != null) {
                                        process.destroy();
                                    }
                                    throw throwable;
                                }
                            }
                            IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                        }
                        if (bufferedReader != null) {
                            IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                        }
                        if (process != null) {
                            process.destroy();
                        }
                        break block19;
                    }
                    IOUtil.closeQuietly((Closeable[])new Closeable[]{errorReader});
                }
                if (bufferedReader != null) {
                    IOUtil.closeQuietly((Closeable[])new Closeable[]{bufferedReader});
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception e) {
                log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Exception)e));
            }
            catch (Error er) {
                log.error("cmd:{}  run error,{}", (Object)cmd, (Object)ErrorUtil.getStackMsg((Throwable)er));
            }
        }
        return cont;
    }

    private boolean validateCmd(String cmd) {
        if (StringUtils.isBlank((CharSequence)cmd)) {
            return false;
        }
        for (String forbidCmd : this.forbidCmds) {
            if (!cmd.contains(forbidCmd)) continue;
            return false;
        }
        Matcher matcher = this.pattern.matcher(cmd);
        return matcher.find();
    }

    private String deployLibDir() {
        String workDir = "";
        try {
            ApplicationHome h = new ApplicationHome(this.getClass());
            File jarF = h.getSource();
            workDir = jarF.getParentFile().toString();
            log.info("checklogFiles, path:{} ", (Object)workDir);
        }
        catch (Exception e) {
            log.info("checklogFiles, path  error:{} ", (Object)ErrorUtil.getStackMsg((Exception)e));
            workDir = "";
        }
        return workDir;
    }

    private String deployJarDir() {
        String workDir = "";
        try {
            workDir = System.getProperty("user.dir");
            return workDir;
        }
        catch (Exception e) {
            log.info("checklogFiles, path  error:{} ", (Object)ErrorUtil.getStackMsg((Exception)e));
            workDir = "";
            return workDir;
        }
    }

    public String getLogsDir() {
        if (StringUtils.isNotBlank((CharSequence)this.httpConfig.getCusLogDir())) {
            return this.httpConfig.getCusLogDir();
        }
        try {
            org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
            Enumeration allAppenders = rootLogger.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender appender = (Appender)allAppenders.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                FileAppender fileAppender = (FileAppender)appender;
                String fileName = fileAppender.getFile();
                File file = new File(fileName);
                String canonicalPath = file.getCanonicalPath();
                canonicalPath = canonicalPath.substring(0, canonicalPath.lastIndexOf(File.separator));
                log.info("canonicalPath= {}", (Object)canonicalPath);
                return canonicalPath;
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.error(ErrorUtil.getStackMsg((Throwable)e));
        }
        return this.deployJarDir() + File.separator + log_folder;
    }

    private String loadOsName() {
        if ("".equals(this.osName)) {
            String name = System.getProperty("os.name");
            log.info("\u5df2\u68c0\u6d4b\u5230\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e3a\uff1a" + name);
            if (this.osName != null) {
                if (name.startsWith("Windows")) {
                    this.osName = "Windows";
                } else if (name.startsWith("Linux") || name.startsWith("Mac")) {
                    this.osName = "Linux";
                } else {
                    this.osName = "noSupport";
                    log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                }
            } else {
                this.osName = "noSupport";
                log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
            }
        }
        return this.osName;
    }

    public void checklogFiles() {
        if (!this.httpConfig.isRemoteLog()) {
            return;
        }
        new Thread(() -> {
            while (true) {
                try {
                    TimeUnit.MINUTES.sleep(3L);
                    String os_name = this.loadOsName();
                    if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
                        log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
                        return;
                    }
                    this.doChecklogFiles();
                    continue;
                }
                catch (Exception e) {
                    log.error("checklogFiles error {}", (Object)ErrorUtil.getStackMsg((Exception)e));
                    continue;
                }
                finally {
                    try {
                        TimeUnit.MINUTES.sleep(18L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }).start();
    }

    public void afterPropertiesSet() {
        String os_name = this.loadOsName();
        this.checklogFiles();
        if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
            log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
        } else {
            new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            boolean hasMessage = false;
                            SealedMessage sealedMessage = tasks.take();
                            if (sealedMessage != null) {
                                hasMessage = true;
                                this.doHandlerSealedMessage(sealedMessage);
                            }
                            if (hasMessage) continue;
                            TimeUnit.SECONDS.sleep(1L);
                        }
                    }
                    catch (Exception e) {
                        log.info(ErrorUtil.getStackMsg((Exception)e));
                        continue;
                    }
                    break;
                }
            }, "SysCmdTaskExecutor").start();
        }
    }

    private void doChecklogFiles() {
        String logMoveFolder;
        File moveFolder;
        this.address = IPUtils.getIpAddress();
        String os_name = this.loadOsName();
        if (os_name == null || os_name.equals("") || os_name.equals("noSupport")) {
            log.info("\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u7cfb\u7edf\u4e0d\u652f\u6301\u65e5\u5fd7\u67e5\u8be2");
            return;
        }
        long start = System.currentTimeMillis();
        String logFolder = this.getLogsDir();
        File folder = new File(logFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(moveFolder = new File(logMoveFolder = this.deployJarDir() + File.separator + no_zip_log_folder)).exists()) {
            moveFolder.mkdirs();
        }
        File[] oldMoveFiles = moveFolder.listFiles();
        log.info("logOrgFolder,{}", (Object)logFolder);
        log.info("logMoveFolder,{}", (Object)logMoveFolder);
        String logFileDescribeCachePath = logMoveFolder + File.separator + "logFileDescribeCache.txt";
        LogFileDescribeCacheDto oldCache = MyFileUtils.readCache(logFileDescribeCachePath);
        LogFileDescribeCacheDto newCache = new LogFileDescribeCacheDto();
        File[] files = folder.listFiles();
        ArrayList<File> logFiles = new ArrayList<File>();
        ArrayList<String> fileTimes = new ArrayList<String>();
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    logFiles.add(file);
                    BasicFileAttributes attr1 = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long creationTime = attr1.creationTime().toMillis();
                    long lastModifiedTime = attr1.lastModifiedTime().toMillis();
                    String format = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat sf = new SimpleDateFormat(format);
                    String createTime = sf.format(new Date(creationTime));
                    String modifiedTime = sf.format(new Date(lastModifiedTime));
                    fileTimes.add(createTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(fileTimes, (ct1, ct2) -> ct2.compareTo((String)ct1));
            Collections.sort(logFiles, (file1, file2) -> {
                try {
                    BasicFileAttributes attr1 = Files.readAttributes(file1.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    BasicFileAttributes attr2 = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long creationTime1 = attr1.creationTime().toMillis();
                    long lastModifiedTime1 = attr1.lastModifiedTime().toMillis();
                    long creationTime2 = attr2.creationTime().toMillis();
                    long lastModifiedTime2 = attr2.lastModifiedTime().toMillis();
                    if (lastModifiedTime2 != lastModifiedTime1) {
                        return lastModifiedTime2 > lastModifiedTime1 ? 1 : -1;
                    }
                    if (creationTime2 != creationTime1) {
                        return creationTime2 > creationTime1 ? 1 : -1;
                    }
                    return file2.getAbsoluteFile().compareTo(file1.getAbsoluteFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return file2.getAbsoluteFile().compareTo(file1.getAbsoluteFile());
                }
            });
            int maxParseFileSize = 20;
            int hasParseFileSize = 0;
            for (File file : logFiles) {
                if (hasParseFileSize >= maxParseFileSize) continue;
                try {
                    String lastBusinessDay;
                    boolean isToday;
                    List<String> dateTimes;
                    String today;
                    if (!file.isFile()) continue;
                    String fileName = file.getName();
                    String filePath = file.getAbsolutePath();
                    LogFileDescribeDto newLogFileDescribe = oldCache.getTargetFile(filePath);
                    BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long creationTime = attr.creationTime().toMillis();
                    long lastModifiedTime = attr.lastModifiedTime().toMillis();
                    if (fileName.indexOf(".gz") > 0) {
                        if (newLogFileDescribe == null) {
                            ++hasParseFileSize;
                            newLogFileDescribe = os_name.equals("Windows") ? this.buildLogFileDescribeInWindows(logMoveFolder, file, creationTime, lastModifiedTime, fileTimes) : this.buildLogFileDescribeInLinux(logMoveFolder, file, creationTime, lastModifiedTime, fileTimes);
                        }
                    } else if (newLogFileDescribe == null) {
                        newLogFileDescribe = new LogFileDescribeDto();
                        newLogFileDescribe.setLogFileFullPath(filePath);
                        newLogFileDescribe.setChangeFlag(1);
                        newLogFileDescribe.setCreationTime(creationTime);
                        newLogFileDescribe.setLastModifiedTime(lastModifiedTime);
                        ++hasParseFileSize;
                        if (this.httpConfig.isDecisionContentTimeUseFileTime()) {
                            this.decisionContentTimeUseFileTime(creationTime, lastModifiedTime, fileTimes, newLogFileDescribe);
                        } else if (os_name.equals("Windows")) {
                            SysCmdHandler.detectionContentTimeInWindows(newLogFileDescribe);
                        } else {
                            this.detectionContentTimeInLinux(newLogFileDescribe);
                        }
                        today = DateUtils.format(new Date(), "yyyy-MM-dd");
                        dateTimes = newLogFileDescribe.getDateTimes();
                        if (dateTimes != null && dateTimes.size() > 0 && !(isToday = today.equals(lastBusinessDay = dateTimes.get(dateTimes.size() - 1)))) {
                            newLogFileDescribe.setChangeFlag(2);
                        }
                    } else if (newLogFileDescribe.getCreationTime() != creationTime || newLogFileDescribe.getLastModifiedTime() != lastModifiedTime) {
                        ++hasParseFileSize;
                        newLogFileDescribe.setCreationTime(creationTime);
                        newLogFileDescribe.setLastModifiedTime(lastModifiedTime);
                        newLogFileDescribe.setChangeFlag(1);
                        if (this.httpConfig.isDecisionContentTimeUseFileTime()) {
                            this.decisionContentTimeUseFileTime(creationTime, lastModifiedTime, fileTimes, newLogFileDescribe);
                        } else if (os_name.equals("Windows")) {
                            SysCmdHandler.detectionContentTimeInWindows(newLogFileDescribe);
                        } else {
                            this.detectionContentTimeInLinux(newLogFileDescribe);
                        }
                        today = DateUtils.format(new Date(), "yyyy-MM-dd");
                        dateTimes = newLogFileDescribe.getDateTimes();
                        if (dateTimes != null && dateTimes.size() > 0 && !(isToday = today.equals(lastBusinessDay = dateTimes.get(dateTimes.size() - 1)))) {
                            newLogFileDescribe.setChangeFlag(2);
                        }
                    }
                    newCache.putTargetFile(filePath, newLogFileDescribe);
                }
                catch (Exception e) {
                    log.info("checklogFiles error: {} ", (Object)ErrorUtil.getStackMsg((Exception)e));
                }
                catch (Error e) {
                    log.info("checklogFiles error: {} ", (Object)ErrorUtil.getStackMsg((Throwable)e));
                }
            }
        }
        try {
            if (oldMoveFiles != null && oldMoveFiles.length > 0) {
                for (File oldMoveFile : oldMoveFiles) {
                    String srcPath;
                    if (oldMoveFile.getAbsolutePath().indexOf("logFileDescribeCache") > -1 || !StringUtils.isBlank((CharSequence)(srcPath = newCache.getDec2SrcMap().get(oldMoveFile.getAbsolutePath()))) || oldMoveFile == null || !oldMoveFile.exists() || !oldMoveFile.isFile()) continue;
                    oldMoveFile.delete();
                }
            }
        }
        catch (Exception e) {
            log.info("checklogFiles error: {} ", (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.info("checklogFiles error: {} ", (Object)ErrorUtil.getStackMsg((Throwable)e));
        }
        MyFileUtils.writeCache(logFileDescribeCachePath, newCache);
        this.logFileDescribeCache = newCache;
        long end = System.currentTimeMillis();
        long cost = end - start;
        log.info("checklogFiles cost:{} ", (Object)cost);
    }

    private LogFileDescribeDto buildLogFileDescribeInWindows(String logMoveFolder, File file, long creationTime, long lastModifiedTime, List<String> fileTimes) {
        LogFileDescribeDto oldLogFileDescribe = new LogFileDescribeDto();
        String newFileName = System.currentTimeMillis() + UUID.randomUUID().toString().replaceAll("-", "");
        String newFilePath = logMoveFolder + File.separator + newFileName + ".txt";
        MyFileUtils.writeUnGzip(file.getAbsolutePath(), newFilePath);
        oldLogFileDescribe.setLogFileFullPath(newFilePath);
        oldLogFileDescribe.setChangeFlag(2);
        oldLogFileDescribe.setCreationTime(creationTime);
        oldLogFileDescribe.setLastModifiedTime(lastModifiedTime);
        if (this.httpConfig.isDecisionContentTimeUseFileTime()) {
            this.decisionContentTimeUseFileTime(creationTime, lastModifiedTime, fileTimes, oldLogFileDescribe);
        } else {
            SysCmdHandler.detectionContentTimeInWindows(oldLogFileDescribe);
        }
        return oldLogFileDescribe;
    }

    private static void detectionContentTimeInWindows(LogFileDescribeDto oldLogFileDescribe) {
        try {
            ArrayList<String> dateTimes = new ArrayList<String>();
            oldLogFileDescribe.setDateTimes(dateTimes);
            Scanner scanner = new Scanner(new File(oldLogFileDescribe.getLogFileFullPath()));
            String firstLine = "";
            String lastLine = "";
            String startDateTime = "";
            String endDateTime = "";
            int readIndex = 0;
            while (scanner.hasNextLine()) {
                lastLine = scanner.nextLine();
                if (readIndex == 0) {
                    firstLine = lastLine;
                }
                ++readIndex;
            }
            scanner.close();
            if (readIndex > 0 && StringUtils.isNotBlank((CharSequence)firstLine)) {
                Pattern p = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})");
                Matcher m = p.matcher(firstLine);
                if (m.find()) {
                    startDateTime = m.group(0);
                }
                if (readIndex > 1 && StringUtils.isNotBlank((CharSequence)lastLine) && (m = p.matcher(lastLine)).find()) {
                    endDateTime = m.group(0);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)startDateTime) && StringUtils.isNotBlank((CharSequence)endDateTime)) {
                if (startDateTime.equals(endDateTime)) {
                    dateTimes.add(startDateTime);
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    List<String> dates = DateUtils.getRangeDate(format.parse(startDateTime), format.parse(endDateTime), 5, "yyyy-MM-dd");
                    if (CollectionUtils.isNotEmpty(dates)) {
                        oldLogFileDescribe.setDateTimes(dates);
                    } else {
                        String businessDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(oldLogFileDescribe.getLastModifiedTime() - 2000L));
                        dateTimes.add(businessDate);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)startDateTime)) {
                dateTimes.add(startDateTime);
            } else if (StringUtils.isNotBlank((CharSequence)endDateTime)) {
                dateTimes.add(endDateTime);
            } else {
                String businessDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(oldLogFileDescribe.getLastModifiedTime() - 2000L));
                dateTimes.add(businessDate);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)ErrorUtil.getStackMsg((Exception)e));
            oldLogFileDescribe.setDateTimes(new ArrayList<String>());
        }
    }

    private LogFileDescribeDto buildLogFileDescribeInLinux(String logMoveFolder, File file, long creationTime, long lastModifiedTime, List<String> fileTimes) {
        LogFileDescribeDto oldLogFileDescribe = new LogFileDescribeDto();
        if (this.httpConfig.isCopLogFile()) {
            String newFileName = System.currentTimeMillis() + UUID.randomUUID().toString().replaceAll("-", "");
            String newFilePath = logMoveFolder + File.separator + newFileName + ".gz";
            MyFileUtils.copyFile(file, new File(newFilePath));
            oldLogFileDescribe.setLogFileFullPath(newFilePath);
        } else {
            oldLogFileDescribe.setLogFileFullPath(file.getAbsolutePath());
        }
        oldLogFileDescribe.setChangeFlag(2);
        oldLogFileDescribe.setCreationTime(creationTime);
        oldLogFileDescribe.setLastModifiedTime(lastModifiedTime);
        if (this.httpConfig.isDecisionContentTimeUseFileTime()) {
            this.decisionContentTimeUseFileTime(creationTime, lastModifiedTime, fileTimes, oldLogFileDescribe);
        } else {
            this.detectionContentTimeInLinux(oldLogFileDescribe);
        }
        return oldLogFileDescribe;
    }

    private void decisionContentTimeUseFileTime(long creationTime, long lastModifiedTime, List<String> fileTimes, LogFileDescribeDto oldLogFileDescribe) {
        long now = System.currentTimeMillis();
        if (lastModifiedTime - creationTime <= 2000L && now - lastModifiedTime >= 2000L) {
            String format = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sf = new SimpleDateFormat(format);
            String createTime = sf.format(new Date(creationTime));
            String createDay = createTime.substring(0, 10);
            boolean hasEarlierFile = false;
            for (String fileTime : fileTimes) {
                String fileDay = fileTime.substring(0, 10);
                if (fileTime.compareTo(createTime) >= 0 || fileDay.compareTo(createDay) >= 0) continue;
                try {
                    List<String> dates = DateUtils.getRangeDate(sf.parse(fileTime), new Date(creationTime), 5, "yyyy-MM-dd");
                    oldLogFileDescribe.setDateTimes(dates);
                }
                catch (Exception e) {
                    log.error(ErrorUtil.getStackMsg((Exception)e));
                }
                hasEarlierFile = true;
                break;
            }
            if (!hasEarlierFile) {
                String os_name = this.loadOsName();
                if (os_name.equals("Windows")) {
                    SysCmdHandler.detectionContentTimeInWindows(oldLogFileDescribe);
                } else {
                    this.detectionContentTimeInLinux(oldLogFileDescribe);
                }
            }
        } else {
            List<String> dates = DateUtils.getRangeDate(new Date(creationTime), new Date(lastModifiedTime), 5, "yyyy-MM-dd");
            if (CollectionUtils.isNotEmpty(dates)) {
                oldLogFileDescribe.setDateTimes(dates);
            }
        }
        if (CollectionUtils.isEmpty(oldLogFileDescribe.getDateTimes())) {
            String businessDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastModifiedTime - 2000L));
            ArrayList<String> dateTimes = new ArrayList<String>();
            dateTimes.add(businessDate);
            oldLogFileDescribe.setDateTimes(dateTimes);
        }
    }

    private void detectionContentTimeInLinux(LogFileDescribeDto oldLogFileDescribe) {
        try {
            ArrayList<String> dateTimes = new ArrayList<String>();
            oldLogFileDescribe.setDateTimes(dateTimes);
            String firstLine = "";
            String lastLine = "";
            StringBuilder sb = new StringBuilder();
            String newFilePath = oldLogFileDescribe.getLogFileFullPath();
            long lastModifiedTime = oldLogFileDescribe.getLastModifiedTime();
            String firstCmd = sb.append("zcat ").append(newFilePath).append(" | head -1 ").toString();
            if (newFilePath.indexOf(".gz") == -1) {
                firstCmd = sb.append("cat ").append(newFilePath).append(" | head -1 ").toString();
            }
            String lastCmd = sb.append("zcat ").append(newFilePath).append(" | tail -1 ").toString();
            if (newFilePath.indexOf(".gz") == -1) {
                lastCmd = sb.append("cat ").append(newFilePath).append(" | tail -1 ").toString();
            }
            firstLine = this.doCmd(firstCmd);
            lastLine = this.doCmd(lastCmd);
            String startDateTime = "";
            String endDateTime = "";
            if (StringUtils.isNotBlank((CharSequence)firstLine)) {
                Pattern p = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})");
                Matcher m = p.matcher(firstLine);
                if (m.find()) {
                    startDateTime = m.group(0);
                }
                if (StringUtils.isNotBlank((CharSequence)lastLine) && (m = p.matcher(lastLine)).find()) {
                    endDateTime = m.group(0);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)startDateTime) && StringUtils.isNotBlank((CharSequence)endDateTime)) {
                if (startDateTime.equals(endDateTime)) {
                    dateTimes.add(startDateTime);
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    List<String> dates = DateUtils.getRangeDate(format.parse(startDateTime), format.parse(endDateTime), 5, "yyyy-MM-dd");
                    if (CollectionUtils.isNotEmpty(dates)) {
                        oldLogFileDescribe.setDateTimes(dates);
                    } else {
                        String businessDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastModifiedTime - 2000L));
                        dateTimes.add(businessDate);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)startDateTime)) {
                dateTimes.add(startDateTime);
            } else if (StringUtils.isNotBlank((CharSequence)endDateTime)) {
                dateTimes.add(endDateTime);
            } else {
                String businessDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastModifiedTime - 2000L));
                dateTimes.add(businessDate);
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)ErrorUtil.getStackMsg((Exception)e));
        }
    }

    public static void main(String[] args) {
        String logFolder = "D:\\pyt\\gateway\\aided-api\\src\\main\\resources\\dev\\logs";
        File folder = new File(logFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] files = folder.listFiles();
        ArrayList<File> logFiles = new ArrayList<File>();
        if (files != null && files.length > 0) {
            for (File file : files) {
                logFiles.add(file);
            }
            Collections.sort(logFiles, (file1, file2) -> {
                try {
                    BasicFileAttributes attr1 = Files.readAttributes(file1.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    BasicFileAttributes attr2 = Files.readAttributes(file2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long creationTime1 = attr1.creationTime().toMillis();
                    long lastModifiedTime1 = attr1.lastModifiedTime().toMillis();
                    long creationTime2 = attr2.creationTime().toMillis();
                    long lastModifiedTime2 = attr2.lastModifiedTime().toMillis();
                    if (lastModifiedTime2 != lastModifiedTime1) {
                        return lastModifiedTime2 > lastModifiedTime1 ? 1 : -1;
                    }
                    if (creationTime2 != creationTime1) {
                        return creationTime2 > creationTime1 ? 1 : -1;
                    }
                    return file2.getAbsoluteFile().compareTo(file1.getAbsoluteFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return file2.getAbsoluteFile().compareTo(file1.getAbsoluteFile());
                }
            });
            for (int i = 0; i < logFiles.size(); ++i) {
                try {
                    File file = (File)logFiles.get(i);
                    BasicFileAttributes attr1 = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long creationTime = attr1.creationTime().toMillis();
                    long lastModifiedTime = attr1.lastModifiedTime().toMillis();
                    String format = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat sf = new SimpleDateFormat(format);
                    String createTime = sf.format(new Date(creationTime));
                    String modifiedTime = sf.format(new Date(lastModifiedTime));
                    log.info("filename:{},createTime:{} ,modifiedTime{} ", new Object[]{file.getName(), createTime, modifiedTime});
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setJanusUploader(JanusUploader janusUploader) {
        this.janusUploader = janusUploader;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

