/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.dto;

public class Result<T> {
    private String code;
    private String message;
    private T result;

    public Result(ResultCode responseCode) {
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public Result(T result, ResultCode responseCode) {
        this.result = result;
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public static <T> Result<T> ok(T body) {
        Result<T> response = new Result<T>();
        response.setResult(body);
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public static <T> Result<T> ok() {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ")";
    }

    public Result() {
    }

    public Result(String code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public static enum ResultCode {
        OK("1", "\u5904\u7406\u6210\u529f"),
        FAILED("0", "\u5904\u7406\u5931\u8d25");

        private final String code;
        private final String message;

        private ResultCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

