/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.InternalListener;
import com.xforceplus.janus.framework.event.dto.ClientInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class ProjectClientInitHandler
implements ConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(ProjectClientInitHandler.class);
    private InternalListener messageListener;
    private HttpConfig httpConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doHandler(String body) {
        try {
            if (StringUtils.isNotBlank((CharSequence)body) && MCFactory.getInstance() == null) return;
        }
        catch (RuntimeException ex) {
            ClientInfo clientInfo = (ClientInfo)JacksonUtil.getInstance().fromJson(body, ClientInfo.class);
            MCFactory mcFactory = null;
            mcFactory = this.httpConfig != null && StringUtils.isNotBlank((CharSequence)this.httpConfig.getTcpProxyHost()) ? MCFactory.getInstance((String)clientInfo.getClientId(), (String)this.httpConfig.getTcpProxyHost(), (int)this.httpConfig.getTcpProxyPort()) : MCFactory.getInstance((String)clientInfo.getClientId(), (String)clientInfo.getUrl(), (int)clientInfo.getPort());
            mcFactory.registerListener((IMessageListener)this.messageListener);
            mcFactory.setAutoAck(false);
            return;
        }
    }

    public String getConfigKey() {
        return "client";
    }

    public void setMessageListener(InternalListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

