/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.framework.event.AckTuple;
import com.xforceplus.janus.framework.event.DefaultSealedMessageEventListener;
import com.xforceplus.janus.framework.event.EventInitListener;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class SealedMessageEventBus {
    private static final Logger log = LoggerFactory.getLogger(SealedMessageEventBus.class);
    private DefaultSealedMessageEventListener defaultSealedMessageEventListener;

    @Async(value="sealedEventTaskExecutor")
    @EventListener(classes={SealedMessageEvent.class})
    public void sealedMessageEvent(SealedMessageEvent event) {
        ISealedMessageEventListener sealedMessageEventListener = EventInitListener.EVENT_HANDLERS.get(event.getRequestName());
        if (null == sealedMessageEventListener && null == (sealedMessageEventListener = EventInitListener.EVENT_HANDLERS.get("*"))) {
            sealedMessageEventListener = this.defaultSealedMessageEventListener;
        }
        AckTuple<Boolean, String> ackTuple = null;
        try {
            ackTuple = sealedMessageEventListener.onEvent(event);
        }
        catch (Exception ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)event.getSealedMessage().getHeader().getMsgId(), (Object)ErrorUtil.getStackMsg((Exception)ex));
            try {
                MCFactory.getInstance().sendMessage(SealedMessageBuilder.buildReceiptMessage((SealedMessage)event.getSealedMessage(), (boolean)false, (String)ex.getMessage()));
            }
            catch (Exception recpEx) {
                log.error(ErrorUtil.getStackMsg((Exception)recpEx));
            }
        }
        if (null == ackTuple) {
            log.error("{} \u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9\uff01\uff01\uff01", (Object)event.getSealedMessage().getHeader().getMsgId());
            return;
        }
        SealedMessage sealedMessage = event.getSealedMessage();
        if (sealedMessage.getHeader().getRequestName().contains("request_receipt") || sealedMessage.getHeader().getRequestName().contains("keepAlived")) {
            return;
        }
        try {
            MCFactory.getInstance().sendMessage(SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)ackTuple.getStatus(), (String)ackTuple.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001\u56de\u6267\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    public DefaultSealedMessageEventListener getDefaultSealedMessageEventListener() {
        return this.defaultSealedMessageEventListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SealedMessageEventBus)) {
            return false;
        }
        SealedMessageEventBus other = (SealedMessageEventBus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DefaultSealedMessageEventListener this$defaultSealedMessageEventListener = this.getDefaultSealedMessageEventListener();
        DefaultSealedMessageEventListener other$defaultSealedMessageEventListener = other.getDefaultSealedMessageEventListener();
        return !(this$defaultSealedMessageEventListener == null ? other$defaultSealedMessageEventListener != null : !this$defaultSealedMessageEventListener.equals(other$defaultSealedMessageEventListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SealedMessageEventBus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultSealedMessageEventListener $defaultSealedMessageEventListener = this.getDefaultSealedMessageEventListener();
        result = result * 59 + ($defaultSealedMessageEventListener == null ? 43 : $defaultSealedMessageEventListener.hashCode());
        return result;
    }

    public String toString() {
        return "SealedMessageEventBus(defaultSealedMessageEventListener=" + this.getDefaultSealedMessageEventListener() + ")";
    }

    public void setDefaultSealedMessageEventListener(DefaultSealedMessageEventListener defaultSealedMessageEventListener) {
        this.defaultSealedMessageEventListener = defaultSealedMessageEventListener;
    }
}

