/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContent;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.service.AccessRecordService;

@JanusCmdAnnotation(sourceType="getRequestRecordDetails")
public class RequestRecordDetailCmdHandler
implements IJanusCmdHandler {
    JanusUploader janusUploader;
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = (String)sealedMessage.getHeader().getOthers().get("businessTime");
        String contentId = (String)sealedMessage.getHeader().getOthers().get("contentId");
        AccessContent content = this.accessRecordService.queryByConentId(contentId, requstTime);
        AccessContentDto contenDto = null;
        Result<Object> result = null;
        if (content != null) {
            contenDto = (AccessContentDto)JacksonUtil.getInstance().fromJson(content.getContent(), AccessContentDto.class);
            result = Result.ok(contenDto);
        } else {
            result = new Result<Object>(null, Result.ResultCode.FAILED);
        }
        this.janusUploader.sendJanusCmdResult((String)sealedMessage.getHeader().getOthers().get("sourceType"), (String)sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    public void setJanusUploader(JanusUploader janusUploader) {
        this.janusUploader = janusUploader;
    }

    public void setAccessRecordService(AccessRecordService accessRecordService) {
        this.accessRecordService = accessRecordService;
    }
}

