/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import com.xforceplus.apollo.utils.Base64Util;
import com.xforceplus.apollo.utils.code.GZipUtils;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.interceptor.CustomHttpServletRequestWrapper;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class BigRequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BigRequestInterceptor.class);
    private BigDataTmpRepository bigDataTmpRepository;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String contentEncoding = request.getHeader("Content-Encoding");
        String taskId = request.getHeader("big-data-split-task-id");
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            int splitCount = Integer.valueOf(request.getHeader("big-data-split-count"));
            int splitIndex = Integer.valueOf(request.getHeader("big-data-split-index"));
            String body = null;
            if (request instanceof CustomHttpServletRequestWrapper) {
                body = this.getRequestBody((CustomHttpServletRequestWrapper)request).toString();
            }
            if (splitCount - 1 == splitIndex) {
                List<BigRequestTmpDto> dataDetails = this.bigDataTmpRepository.getByTaskId(taskId);
                for (int outTimes = 0; (CollectionUtils.isEmpty(dataDetails) || dataDetails.size() - 1 != splitCount) && outTimes < 9; ++outTimes) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dataDetails = this.bigDataTmpRepository.getByTaskId(taskId);
                }
                if (CollectionUtils.isNotEmpty(dataDetails) && dataDetails.size() == splitCount - 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    dataDetails.forEach(bq -> stringBuilder.append(bq.getContent()));
                    stringBuilder.append(body);
                    byte[] decodeChar = Base64Util.decode((byte[])stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    if (request instanceof CustomHttpServletRequestWrapper) {
                        byte[] ungzipBody = GZipUtils.ungzip((byte[])decodeChar);
                        ((CustomHttpServletRequestWrapper)request).setBody(new String(ungzipBody).getBytes());
                    }
                    response.addHeader("big-request-finish", "true");
                    return true;
                }
                String sjycBody = "{\"code\":\"0\",\"message\":\"\u5927\u62a5\u6587\u62c6\u5206\u5f02\u5e38\u6570\u636e\u4e0d\u5168\"}";
                response.getWriter().write(sjycBody);
                return false;
            }
            BigRequestTmpDto requestBody = new BigRequestTmpDto(taskId, splitIndex, body, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.bigDataTmpRepository.saveBigDataTmp(requestBody);
            String sjycBody = "{\"code\":\"1\",\"message\":\"\u5df2\u7ecf\u4e0a\u4f20\",\"big-request-finish\":false}";
            response.addHeader("big-request-finish", "false");
            response.getWriter().write(sjycBody);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuilder getRequestBody(CustomHttpServletRequestWrapper request) {
        StringBuilder requestBodySB = new StringBuilder();
        try (BufferedReader br = request.getReader();){
            String line = null;
            while ((line = br.readLine()) != null) {
                requestBodySB.append(line);
            }
            br.close();
            StringBuilder stringBuilder = requestBodySB;
            return stringBuilder;
        }
        catch (IOException iOException) {
            return requestBodySB;
        }
    }

    public void setBigDataTmpRepository(BigDataTmpRepository bigDataTmpRepository) {
        this.bigDataTmpRepository = bigDataTmpRepository;
    }
}

