/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class CustomHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;
    private Map<String, String> headerMap = new HashMap<String, String>();

    public CustomHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body == null) {
            this.body = new byte[0];
        }
        final ByteArrayInputStream bodyStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bodyStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        for (String name : this.headerMap.keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values.add(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

