/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CustomHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private HttpServletResponse response;
    private PrintWriter pwrite;

    public CustomHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new MyServletOutputStream(this.bytes);
    }

    public PrintWriter getWriter() throws IOException {
        try {
            this.pwrite = new PrintWriter(new OutputStreamWriter((OutputStream)this.bytes, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.pwrite;
    }

    public byte[] getBytes() {
        if (null != this.pwrite) {
            this.pwrite.close();
            return this.bytes.toByteArray();
        }
        if (null != this.bytes) {
            try {
                this.bytes.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.bytes.toByteArray();
    }

    class MyServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream ostream;

        public MyServletOutputStream(ByteArrayOutputStream ostream) {
            this.ostream = ostream;
        }

        public void write(int b) throws IOException {
            this.ostream.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener listener) {
        }
    }
}

